/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template;

/**
 * List values in a template data model must implement this interface,
 * which is essentially the <tt>Iterator</tt> interface plus a
 * <tt>rewind()</tt> method that allows the list to be read
 * again.
 *
 * <p>The detail messages of any <tt>TemplateModelException</tt>s
 * thrown will be included as HTML comments in the output.
 */
public interface TemplateListModel extends TemplateModel {

    /**
     * Resets the cursor to the beginning of the list.
     */
    public void rewind() throws TemplateModelException;

    /**
     * @return true if the cursor is at the beginning of the list.
     */
    public boolean isRewound() throws TemplateModelException;

    /**
     * @return true if there is a next element.
     */
    public boolean hasNext() throws TemplateModelException;

    /**
     * @return the next element in the list.
     */
    public TemplateModel next() throws TemplateModelException;
  
    /**
     * @return the specified index in the list
     */
    public TemplateModel get(int i) throws TemplateModelException;

}
