/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

package freemarker.template;

import java.util.EventObject;

/**
 * An event fired by self-updating caches.
 */
public class CacheEvent extends EventObject {

    /**
     * @serial an <tt>Exception</tt> associated with this event.
     */
    private Exception exception;

    /**
     * @serial the name of an element associated with this event.
     */
    private String elementName;

    public CacheEvent(Object source) {
		super(source);
    }

    /**
     * @param exception an <tt>Exception</tt> associated with this event.
     */
    public void setException(Exception exception) {
		this.exception = exception;
    }

    /**
     * @return the <tt>Exception</tt>, if any, associated with this
     * event.
     */
    public Exception getException() {
		return exception;
    }

    /**
     * @param elementName the name of the cache element associated with this event.
     */
    public void setElementName(String elementName) {
		this.elementName = elementName;
    }

    /**
     * @return the name of the cache element, if any, associated with this
     * event.
     */
    public String getElementName() {
		return elementName;
    }
}
