/*
 * FreeMarker: a tool that allows Java programs to generate HTML
 * output using templates.
 * Copyright (C) 1998 Benjamin Geer
 * Email: beroul@yahoo.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
 
package freemarker.template;

import java.util.Iterator;

/**
 * An interface for self-updating caches of compiled <tt>BinaryData</tt>s.
 *
 * @see freemarker.template.FileBinaryCache
 */
public interface BinaryCache {
    /**
     * Registers a <tt>CacheListener</tt> for this <tt>BinaryCache</tt>.
     *
     * @param CacheListener the <tt>CacheListener</tt> to be registered.
     * @see CacheListener
     */
    public void addCacheListener(CacheListener listener);

    /**
     * Unregisters a <tt>CacheListener</tt> for this <tt>BinaryCache</tt>.
     *
     * @param CacheListener the <tt>CacheListener</tt> to be unregistered.
     * @see CacheListener
     */
    public void removeCacheListener(CacheListener listener);

    /**
     * Gets a BinaryData object from the cache.
	 *
	 * @param name a string uniquely identifying the binary data object.
	 * @return the binary data object corresponding to the name, or null if not found.
	 */
    public BinaryData getBinaryData(String name);

    /**
	  * <b>Note: startAutoUpdate() is deprecated</b>. An implementation will
	  * automatically call startAutoUpdate() or its equivalent internally as 
	  * determined by the caching policy
	  * 
	  * <p>
      * Begins automatic updates of the cache. 
	  *
	  * @deprecated 
      */
    public void startAutoUpdate();

    /**
	  * <b>Note: startAutoUpdate() is deprecated</b>. An implementation will
	  * automatically call startAutoUpdate() or its equivalent internally as 
	  * determined by the caching policy
	  *
	  * <p>
      * Stops automatically updating the cache.
	  *
	  * @deprecated
      */
    public void stopAutoUpdate();

    /**
     * Returns an iterator over a list of CacheElement instances
     *
     * @return the iterator over a list of CacheElement instances that
     * correspond to templates in the cache
     */
     public Iterator listCachedFiles();
}
