package guestbook;

import freemarker.template.*;
import java.util.*;

public class GuestbookTM implements TemplateListModel {

    private List entries;
    private ListIterator iterator;

    public GuestbookTM(Guestbook book) {
        this.entries = book.getList();
    }

    public boolean isEmpty() throws TemplateModelException {
        return entries.isEmpty();
    }

    public boolean hasNext() throws TemplateModelException {
        checkIterator();
        return iterator.hasNext();
    }

    public TemplateModel next() throws TemplateModelException {
        checkIterator();
        if (iterator.hasNext()) {
            return new GuestbookEntryTM((GuestbookEntry)iterator.next());
        } else {
            throw new TemplateModelException("No more elements.");
        }
    }

    private void checkIterator() {
        if (iterator == null) {
            iterator = entries.listIterator();
        }
    }

    public void rewind() throws TemplateModelException {
        iterator = null;
    }

    public boolean isRewound() throws TemplateModelException {
        return (iterator == null);
    }

    public TemplateModel get(int i) throws TemplateModelException {
        if ((i >= 0) && (i < entries.size())) {
            return new GuestbookEntryTM((GuestbookEntry)entries.get(i));
        } else {
            throw new TemplateModelException("Index out of range.");
        }
    }
}

