import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import freemarker.template.*;

public class HelloServlet extends HttpServlet {

	private Template template;

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		String templatePath = getServletContext().getRealPath("/hello-world.html");
		try {
			template = new Template(templatePath);
		} catch (IOException e) {
			throw new UnavailableException(this, "Can't load template " +
				templatePath + ": " + e.toString());
		}
	}

	public void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {

		res.setContentType("text/html");
		PrintWriter out = res.getWriter();

		// Make a template data model.
		SimpleHash modelRoot = new SimpleHash();
		modelRoot.put("message", new SimpleScalar("Hello, world!"));

		// Process the template.
		template.process(modelRoot, out);
		out.close();
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException, IOException {
		doGet(req, res);
	}
}
