package org.szegedi.expose.model;

/*
Copyright 1999 by Scriptum, Inc.,
Mlyva utca 34, H-6771 Szeged, Hungary
All rights reserved.

This software is the confidential and proprietary information
of Scriptum, Inc. ("Confidential Information").  You
shall not disclose such Confidential Information and shall use
it only in accordance with the terms of the license agreement
you entered into with Scriptum.
*/

import freemarker.template.*;
import java.util.*;

/**
 * A wrapper for an arbitrary map that will expose it as a {@link TemplateModelRoot}.
 * All values returned from the {@link #get(java.lang.String)} method are automatically
 * passed through {@link ReflectionUtilities.wrap(java.lang.Object)}.
 * @author Attila Szegedi, Scriptum Inc.
 * @version 1.0
 */
public class ReflectionRootModel
implements
	TemplateModelRoot
{
	private Map map;
	
	/**
	 * Creates a new model with its own internal map.
	 */
	public ReflectionRootModel()
	{
		map = new HashMap();	
	}
	
	/**
	 * Creates a new model that adds {@link TemplateModelRoot} behavior to the
	 * passed map.
	 */
	public ReflectionRootModel(Map map)
	{
		this.map = map;
	}
	
	/**
	 * Returns <tt>map.isEmpty()</tt> where <tt>map</tt> is the underlying map.
	 */
	public boolean isEmpty()
	{
		return map.isEmpty();
	}
	
	/**
	 * Returns <tt>ReflectionUtilities.wrap(map.get(key))</tt> where <tt>map</tt> is the underlying map.
	 */
	public TemplateModel get(String key)
	{
		return ReflectionUtilities.wrap(map.get(key));
	}
	
	/**
	 * Puts the specified template model into the map.
	 */
	public void put(String key, TemplateModel model)
	{
		map.put(key, model);
	}
	
	/**
	 * Removes the template model with the specified key from the map.
	 */
	public void remove(String key)
	{
		map.remove(key);
	}
}
