/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Variable;
import freemarker.template.instruction.EmptyInstruction;
import java.io.PrintWriter;

public class VariableInstruction
extends EmptyInstruction {
    private Variable variable;

    public VariableInstruction() {
    }

    public VariableInstruction(Variable variable) {
        this.variable = variable;
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        if (this.variable != null) {
            String string = null;
            try {
                string = this.variable.getValue(templateModelRoot);
            }
            catch (TemplateException templateException) {
                String string2;
                try {
                    string2 = this.variable.getName(templateModelRoot);
                }
                catch (TemplateException templateException2) {
                    printWriter.print(Template.formatErrorMessage("Couldn't get value of variable, or resolve its name: " + templateException2.getMessage()));
                    return;
                }
                printWriter.print(Template.formatErrorMessage("Couldn't get value of variable " + string2 + ": " + templateException.getMessage()));
                return;
            }
            if (string != null) {
                printWriter.print(string);
            }
        }
    }
}

