/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateTransformModel;
import freemarker.template.expression.Variable;
import freemarker.template.instruction.GenericStartInstruction;
import freemarker.template.instruction.Instruction;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class TransformInstruction
extends GenericStartInstruction {
    protected Variable transformVariable;

    public TransformInstruction() {
    }

    public TransformInstruction(Variable variable) {
        this.transformVariable = variable;
    }

    public void setTransformTemplate(Variable variable) {
        this.transformVariable = variable;
    }

    public String getTypeName() {
        return "transform";
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        TemplateModel templateModel;
        String string;
        if (this.transformVariable == null) {
            printWriter.print(Template.formatErrorMessage("Transformation variable undefined."));
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter2 = new PrintWriter(stringWriter);
        this.body.process(templateModelRoot, printWriter2);
        printWriter2.close();
        try {
            string = this.transformVariable.getName(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Couldn't resolve name of transform variable:\n" + templateException.getMessage()));
            return;
        }
        try {
            templateModel = this.transformVariable.getAsTemplateModel(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Couldn't get referent of " + string + ":\n" + templateException.getMessage()));
            return;
        }
        if (templateModel == null) {
            return;
        }
        if (templateModel instanceof TemplateTransformModel) {
            StringReader stringReader = new StringReader(stringWriter.toString());
            try {
                ((TemplateTransformModel)templateModel).transform(stringReader, printWriter);
            }
            catch (TemplateModelException templateModelException) {
                printWriter.print(Template.formatErrorMessage("Couldn't perform transformation " + string + ":\n" + Template.getStackTrace(templateModelException)));
            }
        } else {
            printWriter.print(Template.formatErrorMessage(string + " is not a TemplateTransformModel."));
        }
    }

    public boolean testEndInstruction(Instruction instruction) {
        return instruction.getEndType() == 10;
    }
}

