/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.compiler.RuntimeStructuralElement;
import freemarker.template.compiler.TemplateBuilder;
import freemarker.template.expression.Equals;
import freemarker.template.expression.Expression;
import freemarker.template.instruction.CaseInstruction;
import freemarker.template.instruction.StartInstruction;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SwitchInstruction
extends StartInstruction {
    private List caseInstructions = new LinkedList();
    private CaseInstruction defaultCase;
    private Expression testExpression;

    public SwitchInstruction() {
    }

    public SwitchInstruction(Expression expression) {
        this.setTestExpression(expression);
    }

    public void setTestExpression(Expression expression) {
        this.testExpression = expression;
    }

    public void addCase(CaseInstruction caseInstruction) {
        this.caseInstructions.add(caseInstruction);
        if (caseInstruction.isDefault()) {
            this.defaultCase = caseInstruction;
        }
    }

    public void callBuilder(TemplateBuilder templateBuilder, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        templateBuilder.buildStatement(this, runtimeStructuralElement);
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        Equals equals = new Equals();
        try {
            equals.setLeft(this.testExpression);
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        boolean bl = false;
        Iterator iterator = this.caseInstructions.iterator();
        while (iterator.hasNext()) {
            CaseInstruction caseInstruction = (CaseInstruction)iterator.next();
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
            } else if (!caseInstruction.isDefault()) {
                Expression expression = caseInstruction.getExpression();
                try {
                    equals.setRight(expression);
                    bl2 = equals.isTrue(templateModelRoot);
                }
                catch (TemplateException templateException) {
                    printWriter.print(Template.formatErrorMessage(templateException.getMessage()));
                }
            }
            if (!bl2) continue;
            caseInstruction.process(templateModelRoot, printWriter);
            bl = true;
            if (caseInstruction.hasBreak()) break;
        }
        if (!bl && this.defaultCase != null) {
            this.defaultCase.process(templateModelRoot, printWriter);
        }
    }
}

