/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateListModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateScalarModel;
import freemarker.template.expression.Identifier;
import freemarker.template.expression.Variable;
import freemarker.template.instruction.GenericStartInstruction;
import freemarker.template.instruction.Instruction;
import java.io.PrintWriter;

public class ListInstruction
extends GenericStartInstruction {
    private Variable listVariable;
    private Identifier indexVariable;

    public ListInstruction() {
    }

    public ListInstruction(Variable variable, Identifier identifier) {
        this.setListVariable(variable);
        this.setIndexVariable(identifier);
    }

    public void setListVariable(Variable variable) {
        this.listVariable = variable;
    }

    public void setIndexVariable(Identifier identifier) {
        this.indexVariable = identifier;
    }

    public boolean testEndInstruction(Instruction instruction) {
        return instruction.getEndType() == 6;
    }

    public String getTypeName() {
        return "list";
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        TemplateModel templateModel;
        String string;
        if (this.listVariable == null) {
            printWriter.print(Template.formatErrorMessage("List variable undefined."));
            return;
        }
        if (this.indexVariable == null) {
            printWriter.print(Template.formatErrorMessage("Index variable undefined."));
            return;
        }
        if (this.body == null) {
            return;
        }
        try {
            string = this.listVariable.getName(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Couldn't resolve name of list variable:\n" + templateException.getMessage()));
            return;
        }
        try {
            templateModel = this.listVariable.getAsTemplateModel(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Couldn't get referent of " + string + ":\n" + templateException.getMessage()));
            return;
        }
        if (templateModel == null) {
            return;
        }
        String string2 = null;
        try {
            string2 = this.indexVariable.getName(templateModelRoot);
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        TemplateModel templateModel2 = null;
        try {
            templateModel2 = this.indexVariable.getAsTemplateModel(templateModelRoot);
        }
        catch (TemplateException templateException) {
            // empty catch block
        }
        if (templateModel instanceof TemplateListModel) {
            TemplateListModel templateListModel = (TemplateListModel)templateModel;
            try {
                if (!templateListModel.isRewound()) {
                    templateListModel.rewind();
                }
                while (templateListModel.hasNext()) {
                    TemplateModel templateModel3 = templateListModel.next();
                    templateModelRoot.put(string2, templateModel3);
                    this.body.process(templateModelRoot, printWriter);
                }
            }
            catch (TemplateModelException templateModelException) {
                printWriter.print(Template.formatErrorMessage("Couldn't read from list " + string + ":\n" + Template.getStackTrace(templateModelException)));
            }
        } else if (templateModel instanceof TemplateScalarModel) {
            templateModelRoot.put(string2, templateModel);
            this.body.process(templateModelRoot, printWriter);
        } else {
            printWriter.print(Template.formatErrorMessage(string + " is not a TemplateListModel or a TemplateScalarModel."));
        }
        if (templateModel2 != null) {
            templateModelRoot.put(string2, templateModel2);
        } else {
            templateModelRoot.remove(string2);
        }
    }
}

