/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateCache;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import freemarker.template.instruction.EmptyInstruction;
import freemarker.template.instruction.FunctionInstruction;
import freemarker.template.instruction.FunctionModel;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;

public class IncludeInstruction
extends EmptyInstruction {
    private Template template;
    private Expression templateName;

    public IncludeInstruction() {
    }

    public IncludeInstruction(Template template, Expression expression) {
        this.setTemplate(template);
        this.setIncludedTemplateName(expression);
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setIncludedTemplateName(Expression expression) {
        this.templateName = expression;
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        if (this.template == null) {
            printWriter.print(Template.formatErrorMessage("The TemplateInclude object wasn't given a reference to the current template."));
            return;
        }
        TemplateCache templateCache = this.template.getTemplateCache();
        if (templateCache == null) {
            printWriter.print(Template.formatErrorMessage("The current template wasn't given a reference to a TemplateCache."));
            return;
        }
        String string = null;
        try {
            string = this.templateName.getValue(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Error in template name expression: " + Template.getStackTrace(templateException)));
            return;
        }
        Template template = templateCache.getTemplate(string);
        if (template == null) {
            printWriter.print(Template.formatErrorMessage("Template \"" + string + "\" not found in cache."));
            return;
        }
        this.copyFunctions(this.template, templateModelRoot);
        this.copyFunctions(template, templateModelRoot);
        template.process(templateModelRoot, printWriter);
    }

    private void copyFunctions(Template template, TemplateModelRoot templateModelRoot) {
        Set set = template.getFunctionNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FunctionInstruction functionInstruction = template.getFunction(string);
            templateModelRoot.put(string, new FunctionModel(functionInstruction));
        }
    }
}

