/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateProcessor;
import freemarker.template.compiler.RuntimeStructuralElement;
import freemarker.template.compiler.TemplateBuilder;
import freemarker.template.expression.Expression;
import freemarker.template.instruction.StartInstruction;
import java.io.PrintWriter;

public class IfInstruction
extends StartInstruction {
    private Expression condition;
    private TemplateProcessor ifBlock;
    private TemplateProcessor elseBlock;

    public IfInstruction() {
    }

    public IfInstruction(Expression expression) {
        this.setCondition(expression);
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public void setIfBlock(TemplateProcessor templateProcessor) {
        this.ifBlock = templateProcessor;
    }

    public void setElseBlock(TemplateProcessor templateProcessor) {
        this.elseBlock = templateProcessor;
    }

    public void callBuilder(TemplateBuilder templateBuilder, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        templateBuilder.buildStatement(this, runtimeStructuralElement);
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        boolean bl;
        if (this.condition == null) {
            printWriter.print(Template.formatErrorMessage("Condition undefined."));
            return;
        }
        try {
            bl = this.condition.isTrue(templateModelRoot);
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage(templateException.getMessage()));
            return;
        }
        if (bl) {
            if (this.ifBlock != null) {
                this.ifBlock.process(templateModelRoot, printWriter);
            }
        } else if (this.elseBlock != null) {
            this.elseBlock.process(templateModelRoot, printWriter);
        }
    }
}

