/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import freemarker.template.instruction.EmptyInstruction;
import freemarker.template.instruction.FunctionInstruction;
import freemarker.template.instruction.FunctionModel;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CallInstruction
extends EmptyInstruction {
    private Template template;
    private String functionName;
    private List arguments;

    public CallInstruction(Template template, String string, List list) {
        this.template = template;
        this.functionName = string;
        this.arguments = list;
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        TemplateModel templateModel;
        String string;
        Object object;
        FunctionInstruction functionInstruction = this.template.getFunction(this.functionName);
        if (functionInstruction == null) {
            object = null;
            try {
                object = templateModelRoot.get(this.functionName);
            }
            catch (TemplateModelException templateModelException) {
                printWriter.print(Template.formatErrorMessage("Couldn't get function " + this.functionName + ":\n" + Template.getStackTrace(templateModelException)));
                return;
            }
            if (object instanceof FunctionModel) {
                functionInstruction = ((FunctionModel)object).getFunction();
            }
        }
        if (functionInstruction == null) {
            printWriter.print(Template.formatErrorMessage("Function " + this.functionName + " has not been defined."));
            return;
        }
        object = functionInstruction.getArgumentNames();
        if (object.size() != this.arguments.size()) {
            printWriter.print(Template.formatErrorMessage("Wrong number of arguments in function call."));
            return;
        }
        HashMap<String, TemplateModel> hashMap = new HashMap<String, TemplateModel>();
        Iterator iterator = object.iterator();
        Iterator iterator2 = this.arguments.iterator();
        while (iterator2.hasNext()) {
            string = (String)iterator.next();
            templateModel = null;
            try {
                templateModel = templateModelRoot.get(string);
            }
            catch (TemplateModelException templateModelException) {
                // empty catch block
            }
            if (templateModel != null) {
                hashMap.put(string, templateModel);
            }
            Expression expression = (Expression)iterator2.next();
            TemplateModel templateModel2 = null;
            try {
                templateModel2 = expression.getAsTemplateModel(templateModelRoot);
            }
            catch (TemplateException templateException) {
                printWriter.print(Template.formatErrorMessage(templateException.getMessage()));
                return;
            }
            templateModelRoot.put(string, templateModel2);
        }
        functionInstruction.process(templateModelRoot, printWriter);
        iterator = object.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            templateModel = (TemplateModel)hashMap.get(string);
            if (templateModel != null) {
                templateModelRoot.put(string, templateModel);
                continue;
            }
            templateModelRoot.remove(string);
        }
    }
}

