/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.instruction;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import freemarker.template.expression.Identifier;
import freemarker.template.instruction.EmptyInstruction;
import java.io.PrintWriter;

public class AssignInstruction
extends EmptyInstruction {
    private Identifier variable;
    private Expression value;

    public AssignInstruction() {
    }

    public AssignInstruction(Identifier identifier, Expression expression) {
        this.setVariable(identifier);
        this.setValue(expression);
    }

    public void setVariable(Identifier identifier) {
        this.variable = identifier;
    }

    public void setValue(Expression expression) {
        this.value = expression;
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        if (this.variable == null) {
            printWriter.print(Template.formatErrorMessage("Assignment variable undefined."));
            return;
        }
        if (this.value == null) {
            printWriter.print(Template.formatErrorMessage("Assignment value undefined."));
            return;
        }
        try {
            String string = this.variable.getName(templateModelRoot);
            templateModelRoot.put(string, this.value.getAsTemplateModel(templateModelRoot));
        }
        catch (TemplateException templateException) {
            printWriter.print(Template.formatErrorMessage("Couldn't perform assignment:\n" + templateException.getMessage()));
            return;
        }
    }
}

