/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateScalarModel;
import freemarker.template.expression.Expression;

public abstract class Variable
implements Expression {
    public abstract String getName(TemplateModelRoot var1) throws TemplateException;

    public String getValue(TemplateModelRoot templateModelRoot) throws TemplateException {
        String string;
        TemplateModel templateModel;
        try {
            templateModel = this.getAsTemplateModel(templateModelRoot);
        }
        catch (TemplateException templateException) {
            throw new TemplateException("Couldn't get referent of " + this.getName(templateModelRoot) + ":\n" + templateException.getMessage());
        }
        if (templateModel == null) {
            return null;
        }
        if (!(templateModel instanceof TemplateScalarModel)) {
            throw new TemplateException(this.getName(templateModelRoot) + " is not a TemplateScalarModel, it's a " + templateModel.getClass().getName() + ".");
        }
        try {
            if (templateModel.isEmpty()) {
                return null;
            }
        }
        catch (TemplateModelException templateModelException) {
            throw this.makeReadException(templateModelRoot, templateModelException);
        }
        TemplateScalarModel templateScalarModel = (TemplateScalarModel)templateModel;
        try {
            string = templateScalarModel.getAsString();
        }
        catch (TemplateModelException templateModelException) {
            throw new TemplateException("Couldn't read string value of " + this.getName(templateModelRoot) + ":\n" + Template.getStackTrace(templateModelException));
        }
        return string;
    }

    public boolean isTrue(TemplateModelRoot templateModelRoot) throws TemplateException {
        TemplateModel templateModel = this.getAsTemplateModel(templateModelRoot);
        try {
            return templateModel != null && !templateModel.isEmpty();
        }
        catch (TemplateModelException templateModelException) {
            throw this.makeReadException(templateModelRoot, templateModelException);
        }
    }

    private TemplateException makeReadException(TemplateModelRoot templateModelRoot, Exception exception) throws TemplateException {
        return new TemplateException("Couldn't read from " + this.getName(templateModelRoot) + ":\n" + exception.getMessage());
    }

    public abstract boolean isComplete();

    public abstract TemplateModel getAsTemplateModel(TemplateModelRoot var1) throws TemplateException;
}

