/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;

public class NumberLiteral
implements Expression {
    private Number value;

    public NumberLiteral() {
    }

    public NumberLiteral(String string) {
        this.setValue(string);
    }

    public void setValue(String string) {
        try {
            this.value = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getValue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.value != null ? this.value.toString() : null;
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        return new SimpleScalar(this.getValue(templateModelRoot));
    }

    public boolean isTrue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.value != null;
    }

    public boolean isComplete() {
        return this.value != null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public int intValue() {
        return this.value.intValue();
    }
}

