/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import freemarker.template.expression.ListLiteral;
import freemarker.template.expression.Unary;
import freemarker.template.expression.Variable;
import java.util.List;

public class MethodCall
extends Variable
implements Unary {
    private ListLiteral arguments;
    private Variable target;

    public MethodCall() {
    }

    public MethodCall(List list) {
        this.setArguments(list);
    }

    public void setArguments(List list) {
        this.arguments = new ListLiteral(list);
    }

    public void setTarget(Expression expression) throws TemplateException {
        if (!(expression instanceof Variable) || !expression.isComplete()) {
            throw new TemplateException("Syntax error in expression.");
        }
        this.target = (Variable)expression;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean isComplete() {
        return this.arguments != null && this.target != null;
    }

    public int getAssociationType() {
        return 1;
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        TemplateModel templateModel = this.target.getAsTemplateModel(templateModelRoot);
        if (templateModel == null) {
            return null;
        }
        if (!(templateModel instanceof TemplateMethodModel)) {
            throw new TemplateException(this.target.getName(templateModelRoot) + " is not a TemplateMethodModel, it's a " + templateModel.getClass().getName() + ".");
        }
        TemplateMethodModel templateMethodModel = (TemplateMethodModel)templateModel;
        List list = this.arguments.getValueList(templateModelRoot);
        try {
            return templateMethodModel.exec(list);
        }
        catch (TemplateModelException templateModelException) {
            throw new TemplateException("Error calling method in expression:\n" + Template.getStackTrace(templateModelException));
        }
    }

    public String getName(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.target.getName(templateModelRoot);
    }
}

