/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.SimpleList;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ListLiteral
implements Expression {
    private List values;

    public ListLiteral() {
    }

    public ListLiteral(List list) {
        this.setValue(list);
    }

    public void setValue(List list) {
        this.values = list;
    }

    public String getValue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.values == null ? null : Integer.toString(this.values.size());
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        SimpleList simpleList = new SimpleList();
        if (this.values != null) {
            Iterator iterator = this.values.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                simpleList.add(expression.getAsTemplateModel(templateModelRoot));
            }
        }
        return simpleList;
    }

    public List getValueList(TemplateModelRoot templateModelRoot) throws TemplateException {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.values != null) {
            ListIterator listIterator = this.values.listIterator();
            while (listIterator.hasNext()) {
                Expression expression = (Expression)listIterator.next();
                linkedList.add(expression.getValue(templateModelRoot));
            }
        }
        return linkedList;
    }

    public boolean isTrue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.values != null;
    }

    public boolean isComplete() {
        return this.values != null;
    }
}

