/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.SimpleHash;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HashLiteral
implements Expression {
    private AbstractMap values;

    public HashLiteral() {
    }

    public HashLiteral(List list) throws TemplateException {
        this.setValue(list);
    }

    public void setValue(List list) throws TemplateException {
        HashMap hashMap = new HashMap();
        if (list.size() % 2 != 0) {
            throw new TemplateException("Incorrect number of parameters supplied for a hash literal");
        }
        int n = 0;
        while (n < list.size()) {
            hashMap.put(list.get(n), list.get(n + 1));
            n += 2;
        }
        this.values = hashMap;
    }

    public String getValue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.values == null ? null : Integer.toString(this.values.size());
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        SimpleHash simpleHash = new SimpleHash();
        if (this.values != null) {
            Set set = this.values.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                Expression expression2 = (Expression)this.values.get(expression);
                simpleHash.put(expression.getValue(templateModelRoot), expression2.getAsTemplateModel(templateModelRoot));
            }
        }
        return simpleHash;
    }

    public boolean isTrue(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.values != null;
    }

    public boolean isComplete() {
        return this.values != null;
    }
}

