/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.TemplateException;
import freemarker.template.expression.Binary;
import freemarker.template.expression.CloseParen;
import freemarker.template.expression.Expression;
import freemarker.template.expression.OpenParen;
import freemarker.template.expression.Parenthesis;
import freemarker.template.expression.Unary;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ExpressionBuilder {
    private static final Class[][] opClasses = new Class[][]{{class$freemarker$template$expression$Dot == null ? (class$freemarker$template$expression$Dot = ExpressionBuilder.class$("freemarker.template.expression.Dot")) : class$freemarker$template$expression$Dot, class$freemarker$template$expression$MethodCall == null ? (class$freemarker$template$expression$MethodCall = ExpressionBuilder.class$("freemarker.template.expression.MethodCall")) : class$freemarker$template$expression$MethodCall, class$freemarker$template$expression$DynamicKeyName == null ? (class$freemarker$template$expression$DynamicKeyName = ExpressionBuilder.class$("freemarker.template.expression.DynamicKeyName")) : class$freemarker$template$expression$DynamicKeyName}, {class$freemarker$template$expression$Not == null ? (class$freemarker$template$expression$Not = ExpressionBuilder.class$("freemarker.template.expression.Not")) : class$freemarker$template$expression$Not}, {class$freemarker$template$expression$Concatenate == null ? (class$freemarker$template$expression$Concatenate = ExpressionBuilder.class$("freemarker.template.expression.Concatenate")) : class$freemarker$template$expression$Concatenate}, {class$freemarker$template$expression$Equals == null ? (class$freemarker$template$expression$Equals = ExpressionBuilder.class$("freemarker.template.expression.Equals")) : class$freemarker$template$expression$Equals, class$freemarker$template$expression$NotEquals == null ? (class$freemarker$template$expression$NotEquals = ExpressionBuilder.class$("freemarker.template.expression.NotEquals")) : class$freemarker$template$expression$NotEquals}, {class$freemarker$template$expression$And == null ? (class$freemarker$template$expression$And = ExpressionBuilder.class$("freemarker.template.expression.And")) : class$freemarker$template$expression$And}, {class$freemarker$template$expression$Or == null ? (class$freemarker$template$expression$Or = ExpressionBuilder.class$("freemarker.template.expression.Or")) : class$freemarker$template$expression$Or}};
    private static final int numLevels = opClasses.length;
    private static final String MISMATCHED_PARENS = "Mismatched parentheses.";
    private static final String EMPTY_PARENS = "Empty parentheses.";
    private static final String MISSING_LEFT = "Missing expression to left of operator.";
    private static final String MISSING_RIGHT = "Missing expression to right of operator.";
    private static final String SYNTAX_ERROR = "Syntax error in expression.";
    private static final String PARSER_ERROR = "Parser error in expression.";
    static /* synthetic */ Class class$freemarker$template$expression$Dot;
    static /* synthetic */ Class class$freemarker$template$expression$MethodCall;
    static /* synthetic */ Class class$freemarker$template$expression$DynamicKeyName;
    static /* synthetic */ Class class$freemarker$template$expression$Not;
    static /* synthetic */ Class class$freemarker$template$expression$Concatenate;
    static /* synthetic */ Class class$freemarker$template$expression$Equals;
    static /* synthetic */ Class class$freemarker$template$expression$NotEquals;
    static /* synthetic */ Class class$freemarker$template$expression$And;
    static /* synthetic */ Class class$freemarker$template$expression$Or;

    public static Expression build(List list) throws TemplateException {
        ExpressionBuilder.groupParens(list);
        return ExpressionBuilder.buildExpression(list);
    }

    private static Expression buildExpression(List list) throws TemplateException {
        int n = 0;
        while (list.size() > 1 && n < numLevels) {
            ExpressionBuilder.associateOperators(list, opClasses[n]);
            ++n;
        }
        if (list.size() == 1) {
            Object object = list.get(0);
            if (object instanceof List) {
                object = ExpressionBuilder.buildExpression((List)object);
            }
            if (object instanceof Expression) {
                Expression expression = (Expression)object;
                if (expression.isComplete()) {
                    return expression;
                }
                throw new TemplateException(PARSER_ERROR);
            }
            throw new TemplateException(SYNTAX_ERROR);
        }
        throw new TemplateException(SYNTAX_ERROR);
    }

    private static void groupParens(List list) throws TemplateException {
        Parenthesis parenthesis;
        ListIterator listIterator = list.listIterator();
        while ((parenthesis = ExpressionBuilder.getNextParen(listIterator)) != null) {
            if (parenthesis instanceof CloseParen) {
                throw new TemplateException(MISMATCHED_PARENS);
            }
            listIterator.remove();
            LinkedList linkedList = new LinkedList();
            int n = 1;
            while (listIterator.hasNext()) {
                Object e = listIterator.next();
                listIterator.remove();
                if (e instanceof OpenParen) {
                    ++n;
                } else if (e instanceof CloseParen && --n == 0) break;
                linkedList.add(e);
            }
            if (n > 0) {
                throw new TemplateException(MISMATCHED_PARENS);
            }
            if (linkedList.isEmpty()) {
                throw new TemplateException(EMPTY_PARENS);
            }
            ExpressionBuilder.groupParens(linkedList);
            listIterator.add(linkedList);
        }
    }

    private static Parenthesis getNextParen(ListIterator listIterator) {
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof Parenthesis)) continue;
            return (Parenthesis)e;
        }
        return null;
    }

    private static void associateOperators(List list, Class[] classArray) throws TemplateException {
        ListIterator<Expression> listIterator = list.listIterator();
        block4: while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e instanceof List) {
                listIterator.set(ExpressionBuilder.buildExpression((List)e));
                continue;
            }
            Class<?> clazz = e.getClass();
            int n = 0;
            while (n < classArray.length) {
                if (clazz == classArray[n]) {
                    Expression expression;
                    Expression expression2;
                    if (e instanceof Binary) {
                        expression2 = (Binary)e;
                        if (!expression2.isComplete()) {
                            listIterator.previous();
                            expression = ExpressionBuilder.getPreviousExpression(listIterator);
                            listIterator.next();
                            Expression expression3 = ExpressionBuilder.getNextExpression(listIterator);
                            expression2.setLeft(expression);
                            expression2.setRight(expression3);
                            continue block4;
                        }
                    } else if (e instanceof Unary) {
                        expression2 = (Unary)e;
                        if (!expression2.isComplete()) {
                            switch (expression2.getAssociationType()) {
                                case 0: {
                                    expression = ExpressionBuilder.getNextExpression(listIterator);
                                    break;
                                }
                                case 1: {
                                    listIterator.previous();
                                    expression = ExpressionBuilder.getPreviousExpression(listIterator);
                                    listIterator.next();
                                    break;
                                }
                                default: {
                                    throw new TemplateException(PARSER_ERROR);
                                }
                            }
                            expression2.setTarget(expression);
                        }
                    } else {
                        throw new TemplateException(PARSER_ERROR);
                    }
                }
                ++n;
            }
        }
    }

    private static Expression getPreviousExpression(ListIterator listIterator) throws TemplateException {
        if (!listIterator.hasPrevious()) {
            throw new TemplateException(MISSING_LEFT);
        }
        Object e = listIterator.previous();
        listIterator.remove();
        if (!(e instanceof Expression)) {
            throw new TemplateException(MISSING_LEFT);
        }
        return (Expression)e;
    }

    private static Expression getNextExpression(ListIterator listIterator) throws TemplateException {
        if (!listIterator.hasNext()) {
            throw new TemplateException(MISSING_RIGHT);
        }
        Object e = listIterator.next();
        listIterator.remove();
        if (e instanceof Expression) {
            return (Expression)e;
        }
        if (e instanceof List) {
            return ExpressionBuilder.buildExpression((List)e);
        }
        throw new TemplateException(MISSING_RIGHT);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

