/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateListModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Expression;
import freemarker.template.expression.NumberLiteral;
import freemarker.template.expression.Unary;
import freemarker.template.expression.Variable;

public class DynamicKeyName
extends Variable
implements Unary {
    private Expression nameExpression;
    private Variable target;

    public DynamicKeyName() {
    }

    public DynamicKeyName(Expression expression) {
        this.setNameExpression(expression);
    }

    public void setNameExpression(Expression expression) {
        this.nameExpression = expression;
    }

    public void setTarget(Expression expression) throws TemplateException {
        if (!(expression instanceof Variable) || !expression.isComplete()) {
            throw new TemplateException("Syntax error in expression.");
        }
        this.target = (Variable)expression;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean isComplete() {
        return this.nameExpression != null && this.target != null;
    }

    public int getAssociationType() {
        return 1;
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        TemplateModel templateModel = this.target.getAsTemplateModel(templateModelRoot);
        if (templateModel == null) {
            return null;
        }
        if (templateModel instanceof TemplateListModel) {
            int n;
            if (this.nameExpression instanceof NumberLiteral) {
                n = ((NumberLiteral)this.nameExpression).intValue();
            } else {
                try {
                    n = Integer.parseInt(this.nameExpression.getValue(templateModelRoot));
                }
                catch (NumberFormatException numberFormatException) {
                    if (templateModel instanceof TemplateHashModel) {
                        return this.getHashModel((TemplateHashModel)templateModel, templateModelRoot);
                    }
                    throw new TemplateException("Expression is not a valid index for " + this.target.getName(templateModelRoot));
                }
            }
            try {
                return ((TemplateListModel)templateModel).get(n);
            }
            catch (TemplateModelException templateModelException) {
                if (templateModel instanceof TemplateHashModel) {
                    return this.getHashModel((TemplateHashModel)templateModel, templateModelRoot);
                }
                throw new TemplateException("IndexOutOfBoundsError in " + this.target.getName(templateModelRoot));
            }
        }
        if (templateModel instanceof TemplateHashModel) {
            return this.getHashModel((TemplateHashModel)templateModel, templateModelRoot);
        }
        throw new TemplateException(this.target.getName(templateModelRoot) + " is not a TemplateHashModel or a TemplateListModel or a TemplateHashModel, it's a " + templateModel.getClass().getName() + ".");
    }

    public String getName(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.nameExpression.getValue(templateModelRoot);
    }

    protected TemplateModel getHashModel(TemplateHashModel templateHashModel, TemplateModelRoot templateModelRoot) throws TemplateException {
        TemplateModel templateModel = null;
        String string = this.nameExpression.getValue(templateModelRoot);
        try {
            templateModel = templateHashModel.get(string);
        }
        catch (TemplateModelException templateModelException) {
            throw new TemplateException("Couldn't get referent of " + string + ":\n" + Template.getStackTrace(templateModelException));
        }
        return templateModel;
    }
}

