/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.expression;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelRoot;
import freemarker.template.expression.Binary;
import freemarker.template.expression.Expression;
import freemarker.template.expression.Identifier;
import freemarker.template.expression.Variable;

public class Dot
extends Variable
implements Binary {
    protected Variable left;
    protected Identifier right;

    public String getName(TemplateModelRoot templateModelRoot) throws TemplateException {
        return this.right.getName(templateModelRoot);
    }

    public void setLeft(Expression expression) throws TemplateException {
        if (!(expression instanceof Variable)) {
            throw new TemplateException("Identifier required to left of dot.");
        }
        this.left = (Variable)expression;
    }

    public void setRight(Expression expression) throws TemplateException {
        if (!(expression instanceof Identifier)) {
            throw new TemplateException("Identifier required to right of dot.");
        }
        this.right = (Identifier)expression;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public boolean isComplete() {
        return this.left != null && this.right != null;
    }

    public TemplateModel getAsTemplateModel(TemplateModelRoot templateModelRoot) throws TemplateException {
        TemplateModel templateModel = this.left.getAsTemplateModel(templateModelRoot);
        if (templateModel == null) {
            return null;
        }
        TemplateModel templateModel2 = null;
        if (templateModel instanceof TemplateHashModel) {
            TemplateHashModel templateHashModel = (TemplateHashModel)templateModel;
            try {
                templateModel2 = templateHashModel.get(this.right.getName(templateModelRoot));
            }
            catch (TemplateModelException templateModelException) {
                throw new TemplateException("Couldn't get referent of " + this.right.getName(templateModelRoot) + ":\n" + Template.getStackTrace(templateModelException));
            }
        } else {
            throw new TemplateException(this.left.getName(templateModelRoot) + " is not a TemplateHashModel, it's a " + templateModel.getClass().getName() + ".");
        }
        return templateModel2;
    }
}

