/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.compiler;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.instruction.ContainerInstruction;
import freemarker.template.instruction.Instruction;

public abstract class TemplateParser {
    protected String text;
    protected int textLen;
    protected Template template;
    protected int parsePos = 0;
    protected int previousParsePos = 0;
    protected int foundPos = 0;

    public TemplateParser() {
    }

    public TemplateParser(Template template, String string) {
        this.setTemplate(template);
        this.setText(string);
    }

    public void setText(String string) {
        this.text = string;
        this.textLen = string.length();
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public void setParsePos(int n) {
        this.parsePos = n;
    }

    public int getFoundPos() {
        return this.foundPos;
    }

    public boolean hasMoreText() {
        return this.parsePos < this.textLen;
    }

    public boolean hasTextBefore() {
        return this.foundPos > this.previousParsePos;
    }

    public String getTextBefore() {
        return this.text.substring(this.previousParsePos, this.foundPos);
    }

    public String getRemainingText() {
        return this.text.substring(this.parsePos);
    }

    public abstract Instruction getNextInstruction() throws TemplateException;

    public abstract boolean skipToEndInstruction(ContainerInstruction var1);

    public String atChar(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            if (this.text.charAt(n3) == '\n') {
                ++n2;
            }
            ++n3;
        }
        return " at line " + String.valueOf(n2);
    }
}

