/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.compiler;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.compiler.TemplateParser;
import freemarker.template.expression.And;
import freemarker.template.expression.CloseParen;
import freemarker.template.expression.Concatenate;
import freemarker.template.expression.Dot;
import freemarker.template.expression.DynamicKeyName;
import freemarker.template.expression.Equals;
import freemarker.template.expression.Expression;
import freemarker.template.expression.ExpressionBuilder;
import freemarker.template.expression.ExpressionElement;
import freemarker.template.expression.HashLiteral;
import freemarker.template.expression.Identifier;
import freemarker.template.expression.ListLiteral;
import freemarker.template.expression.MethodCall;
import freemarker.template.expression.Not;
import freemarker.template.expression.NotEquals;
import freemarker.template.expression.NumberLiteral;
import freemarker.template.expression.OpenParen;
import freemarker.template.expression.Or;
import freemarker.template.expression.StringLiteral;
import freemarker.template.expression.Variable;
import freemarker.template.instruction.AssignInstruction;
import freemarker.template.instruction.CallInstruction;
import freemarker.template.instruction.CaseInstruction;
import freemarker.template.instruction.CommentInstruction;
import freemarker.template.instruction.CompressInstruction;
import freemarker.template.instruction.ContainerInstruction;
import freemarker.template.instruction.EndInstruction;
import freemarker.template.instruction.FunctionInstruction;
import freemarker.template.instruction.IfInstruction;
import freemarker.template.instruction.IncludeInstruction;
import freemarker.template.instruction.Instruction;
import freemarker.template.instruction.ListInstruction;
import freemarker.template.instruction.NoParseInstruction;
import freemarker.template.instruction.SwitchInstruction;
import freemarker.template.instruction.TransformInstruction;
import freemarker.template.instruction.VariableInstruction;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class StandardTemplateParser
extends TemplateParser {
    private Map tagMap = new HashMap();
    private Map longOpMap = new HashMap();
    private boolean foundListIndexKeyword;
    private boolean foundForeachIndexKeyword;
    private int parenLevel = 0;
    protected static final String VAR_INSTR_START_CHARS = "${";
    protected static final char VAR_INSTR_END_CHAR = '}';
    protected static final String LIST_TAG = "list";
    protected static final String LIST_INDEX_KEYWORD = "as";
    protected static final String LIST_END_TAG = "/list";
    protected static final String IF_TAG = "if";
    protected static final String ELSE_TAG = "else";
    protected static final String IF_END_TAG = "/if";
    protected static final String SWITCH_TAG = "switch";
    protected static final String SWITCH_END_TAG = "/switch";
    protected static final String CASE_TAG = "case";
    protected static final String BREAK_TAG = "break";
    protected static final String DEFAULT_TAG = "default";
    protected static final String ASSIGN_TAG = "assign";
    protected static final String INCLUDE_TAG = "include";
    protected static final String FUNCTION_TAG = "function";
    protected static final String FUNCTION_END_TAG = "/function";
    protected static final String COMPRESS_TAG = "compress";
    protected static final String COMPRESS_END_TAG = "/compress";
    protected static final String CALL_TAG = "call";
    protected static final char TAG_START_CHAR = '<';
    protected static final char TAG_END_CHAR = '>';
    protected static final char END_TAG_START_CHAR = '/';
    protected static final char QUOTE_CHAR = '\"';
    protected static final char ESCAPE_CHAR = '\\';
    protected static final String COMMENT_TAG = "comment";
    protected static final String COMMENT_END_TAG = "/comment";
    protected static final String NOPARSE_TAG = "noparse";
    protected static final String NOPARSE_TAG_END = "/noparse";
    protected static final String FOREACH_TAG = "foreach";
    protected static final String FOREACH_INDEX_KEYWORD = "in";
    protected static final String FOREACH_END_TAG = "/foreach";
    protected static final String TRANSFORM_TAG = "transform";
    protected static final String TRANSFORM_END_TAG = "/transform";
    protected static final int LONG_OPERATOR_LENGTH = 2;
    protected boolean lastWasIdentifier = false;

    public StandardTemplateParser() {
        this.init();
    }

    public StandardTemplateParser(Template template, String string) {
        super(template, string);
        this.init();
    }

    private void init() {
        this.tagMap.put(LIST_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseListStart();
            }
        });
        this.tagMap.put(LIST_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(6);
            }
        });
        this.tagMap.put(IF_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseIfStart();
            }
        });
        this.tagMap.put(ELSE_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(3);
            }
        });
        this.tagMap.put(IF_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(5);
            }
        });
        this.tagMap.put(SWITCH_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseSwitch();
            }
        });
        this.tagMap.put(SWITCH_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(7);
            }
        });
        this.tagMap.put(CASE_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseCase();
            }
        });
        this.tagMap.put(BREAK_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(0);
            }
        });
        this.tagMap.put(DEFAULT_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseDefault();
            }
        });
        this.tagMap.put(ASSIGN_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseAssign();
            }
        });
        this.tagMap.put(INCLUDE_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseInclude();
            }
        });
        this.tagMap.put(FUNCTION_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseFunction();
            }
        });
        this.tagMap.put(FUNCTION_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(4);
            }
        });
        this.tagMap.put(CALL_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseFunctionCall();
            }
        });
        this.tagMap.put(COMPRESS_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new CompressInstruction();
            }
        });
        this.tagMap.put(COMPRESS_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(2);
            }
        });
        this.tagMap.put(COMMENT_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseComment();
            }
        });
        this.tagMap.put(COMMENT_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(8);
            }
        });
        this.tagMap.put(FOREACH_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseForeachStart();
            }
        });
        this.tagMap.put(FOREACH_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(6);
            }
        });
        this.tagMap.put(NOPARSE_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseNoparseStart();
            }
        });
        this.tagMap.put(NOPARSE_TAG_END, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(9);
            }
        });
        this.tagMap.put(TRANSFORM_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return StandardTemplateParser.this.parseTransformStart();
            }
        });
        this.tagMap.put(TRANSFORM_END_TAG, new Tag(){

            Instruction parse() throws TemplateException {
                return new EndInstruction(10);
            }
        });
        this.longOpMap.put("==", new LongOperator(){

            Expression parse() throws TemplateException {
                StandardTemplateParser.this.parsePos += 2;
                return new Equals();
            }
        });
        this.longOpMap.put("!=", new LongOperator(){

            Expression parse() throws TemplateException {
                StandardTemplateParser.this.parsePos += 2;
                return new NotEquals();
            }
        });
        this.longOpMap.put("&&", new LongOperator(){

            Expression parse() throws TemplateException {
                StandardTemplateParser.this.parsePos += 2;
                return new And();
            }
        });
        this.longOpMap.put("||", new LongOperator(){

            Expression parse() throws TemplateException {
                StandardTemplateParser.this.parsePos += 2;
                return new Or();
            }
        });
    }

    public Instruction getNextInstruction() throws TemplateException {
        this.previousParsePos = this.parsePos;
        while (this.parsePos < this.textLen) {
            if (this.text.startsWith(VAR_INSTR_START_CHARS, this.parsePos)) {
                this.foundPos = this.parsePos;
                return this.parseVariableInstruction();
            }
            if (this.text.charAt(this.parsePos) == '<') {
                int n = this.parsePos++;
                if (!this.findTagNameEnd()) continue;
                String string = this.text.substring(n + 1, this.parsePos);
                Tag tag = (Tag)this.tagMap.get(string);
                if (tag != null) {
                    this.foundPos = n;
                    Instruction instruction = tag.parse();
                    try {
                        this.findTagEnd();
                    }
                    catch (TemplateException templateException) {
                        String string2 = "Syntax error" + this.atChar(this.foundPos) + this.finishErrorMessage(templateException);
                        throw new TemplateException(string2);
                    }
                    return instruction;
                }
            }
            ++this.parsePos;
        }
        this.parsePos = this.previousParsePos;
        return null;
    }

    public boolean skipToEndInstruction(ContainerInstruction containerInstruction) {
        this.previousParsePos = this.parsePos;
        while (this.parsePos < this.textLen) {
            if (this.text.charAt(this.parsePos) == '<') {
                String string;
                Tag tag;
                int n = this.parsePos++;
                if (!this.findTagNameEnd() || this.text.charAt(n + 1) != '/' || (tag = (Tag)this.tagMap.get(string = this.text.substring(n + 1, this.parsePos))) == null) continue;
                this.foundPos = n;
                try {
                    Instruction instruction = tag.parse();
                    if (!containerInstruction.testEndInstruction(instruction)) continue;
                    this.findTagEnd();
                    return true;
                }
                catch (TemplateException templateException) {}
                continue;
            }
            ++this.parsePos;
        }
        this.parsePos = this.previousParsePos;
        return false;
    }

    protected boolean findTagNameEnd() {
        for (int i = this.parsePos; i < this.textLen; ++i) {
            char c = this.text.charAt(i);
            if (Character.isWhitespace(c) || c == '>') {
                this.parsePos = i;
                return true;
            }
            if (this.isIdentifierChar(c) || c == '/') {
                continue;
            }
            return false;
        }
        return false;
    }

    protected void findTagEnd() throws TemplateException {
        this.skipWhitespace();
        if (this.text.charAt(this.parsePos) != '>') {
            throw new TemplateException("Expected end of tag.");
        }
        ++this.parsePos;
    }

    protected Expression parseExpression(boolean bl) throws TemplateException {
        int n = this.parsePos;
        List list = this.tokenizeExpression(bl);
        try {
            return ExpressionBuilder.build(list);
        }
        catch (TemplateException templateException) {
            throw new TemplateException("Syntax error in expression" + this.atChar(n) + this.finishErrorMessage(templateException));
        }
    }

    protected List tokenizeExpression(boolean bl) throws TemplateException {
        this.parenLevel = 0;
        ExpressionElement expressionElement = this.parseElement(bl);
        if (expressionElement == null) {
            throw new TemplateException("Missing expression.");
        }
        LinkedList<ExpressionElement> linkedList = new LinkedList<ExpressionElement>();
        linkedList.add(expressionElement);
        while ((expressionElement = this.parseElement(bl)) != null) {
            linkedList.add(expressionElement);
        }
        return linkedList;
    }

    protected ExpressionElement parseElement(boolean bl) throws TemplateException {
        this.skipWhitespace();
        char c = this.text.charAt(this.parsePos);
        if (this.isIdentifierStartChar(c)) {
            String string = this.parseIdentifierAsString();
            if (string.equals(LIST_INDEX_KEYWORD)) {
                this.foundListIndexKeyword = true;
                this.lastWasIdentifier = false;
                return null;
            }
            if (string.equals(FOREACH_INDEX_KEYWORD)) {
                this.foundForeachIndexKeyword = true;
                this.lastWasIdentifier = false;
                return null;
            }
            this.lastWasIdentifier = true;
            return new Identifier(string);
        }
        String string = this.text.substring(this.parsePos, this.parsePos + 2);
        LongOperator longOperator = (LongOperator)this.longOpMap.get(string);
        if (longOperator != null) {
            this.lastWasIdentifier = false;
            return longOperator.parse();
        }
        switch (c) {
            case '.': {
                ++this.parsePos;
                this.lastWasIdentifier = false;
                return new Dot();
            }
            case '!': {
                ++this.parsePos;
                this.lastWasIdentifier = false;
                return new Not();
            }
            case '+': {
                ++this.parsePos;
                this.lastWasIdentifier = false;
                return new Concatenate();
            }
            case '(': {
                ++this.parenLevel;
                ++this.parsePos;
                if (!this.lastWasIdentifier) {
                    return new OpenParen();
                }
                this.lastWasIdentifier = false;
                return this.parseMethodCall();
            }
            case ')': {
                --this.parenLevel;
                this.lastWasIdentifier = false;
                if (bl && this.parenLevel < 0) {
                    return null;
                }
                ++this.parsePos;
                return new CloseParen();
            }
            case '[': {
                ++this.parsePos;
                if (!this.lastWasIdentifier) {
                    return this.parseListLiteral();
                }
                this.lastWasIdentifier = false;
                DynamicKeyName dynamicKeyName = this.parseDynamicKeyName();
                this.lastWasIdentifier = true;
                return dynamicKeyName;
            }
            case '{': {
                this.lastWasIdentifier = false;
                ++this.parsePos;
                return this.parseHashLiteral();
            }
            case '\"': {
                this.lastWasIdentifier = false;
                return this.parseStringLiteral();
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumberLiteral();
            }
        }
        this.lastWasIdentifier = false;
        return null;
    }

    protected DynamicKeyName parseDynamicKeyName() throws TemplateException {
        int n = this.parsePos;
        Expression expression = this.parseExpression(false);
        if (this.text.charAt(this.parsePos) == ']') {
            ++this.parsePos;
            return new DynamicKeyName(expression);
        }
        throw new TemplateException("Missing closing delimiter for key expression, or illegal character in expression," + this.atChar(n) + ".");
    }

    protected StringLiteral parseStringLiteral() throws TemplateException {
        int n = this.parsePos++;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        block4: while (this.parsePos < this.textLen) {
            char c = this.text.charAt(this.parsePos);
            switch (c) {
                case '\"': {
                    ++this.parsePos;
                    bl = true;
                    break block4;
                }
                case '\\': {
                    ++this.parsePos;
                    if (this.parsePos >= this.textLen) break block4;
                    stringBuffer.append(this.text.charAt(this.parsePos));
                    ++this.parsePos;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    ++this.parsePos;
                }
            }
        }
        if (bl) {
            return new StringLiteral(stringBuffer.toString());
        }
        throw new TemplateException("Unterminated string literal" + this.atChar(n) + ".");
    }

    protected ListLiteral parseListLiteral() throws TemplateException {
        int n = this.parsePos;
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        try {
            while (!this.skipChar(']')) {
                this.skipWhitespace();
                linkedList.add(this.parseExpression(false));
                this.skipChar(',');
            }
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in list literal" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new ListLiteral(linkedList);
    }

    protected HashLiteral parseHashLiteral() throws TemplateException {
        int n = this.parsePos;
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        try {
            while (!this.skipChar('}')) {
                this.skipWhitespace();
                linkedList.add(this.parseExpression(false));
                this.skipChar(',');
            }
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in hash literal" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new HashLiteral(linkedList);
    }

    protected NumberLiteral parseNumberLiteral() throws TemplateException {
        int n = this.parsePos;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        block3: while (this.parsePos < this.textLen) {
            char c = this.text.charAt(this.parsePos);
            switch (c) {
                case ' ': 
                case ')': 
                case '>': 
                case ']': {
                    bl = true;
                    break block3;
                }
                default: {
                    stringBuffer.append(c);
                    ++this.parsePos;
                }
            }
        }
        if (bl) {
            return new NumberLiteral(stringBuffer.toString());
        }
        throw new TemplateException("Unterminated number literal " + this.atChar(n) + ".");
    }

    protected VariableInstruction parseVariableInstruction() throws TemplateException {
        int n = this.parsePos;
        this.parsePos += VAR_INSTR_START_CHARS.length();
        Variable variable = this.parseVariable();
        if (this.text.charAt(this.parsePos) == '}') {
            ++this.parsePos;
            return new VariableInstruction(variable);
        }
        throw new TemplateException("Missing closing delimiter for variable, or illegal character in variable," + this.atChar(n) + ".");
    }

    protected Variable parseVariable() throws TemplateException {
        int n = this.parsePos;
        Expression expression = this.parseExpression(false);
        if (expression instanceof Variable) {
            return (Variable)expression;
        }
        throw new TemplateException("Variable expected" + this.atChar(n) + ".");
    }

    protected Identifier parseIdentifier() throws TemplateException {
        return new Identifier(this.parseIdentifierAsString());
    }

    protected String parseIdentifierAsString() throws TemplateException {
        int n = this.parsePos;
        while (this.parsePos < this.textLen) {
            if (this.isIdentifierChar(this.text.charAt(this.parsePos))) {
                ++this.parsePos;
                continue;
            }
            if (this.parsePos > n && this.isIdentifierStartChar(this.text.charAt(n))) {
                return this.text.substring(n, this.parsePos);
            }
            throw new TemplateException("Identifier expected" + this.atChar(n) + ".");
        }
        throw new TemplateException("Unexpected end of file.");
    }

    protected ListInstruction parseListStart() throws TemplateException {
        Identifier identifier;
        Variable variable;
        int n = this.parsePos;
        try {
            variable = this.parseVariable();
            if (!this.foundListIndexKeyword) {
                throw new TemplateException("Expected 'as'.");
            }
            this.foundListIndexKeyword = false;
            this.skipWhitespace();
            identifier = this.parseIdentifier();
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in list statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new ListInstruction(variable, identifier);
    }

    protected ListInstruction parseForeachStart() throws TemplateException {
        Variable variable;
        Identifier identifier;
        int n = this.parsePos;
        try {
            this.skipWhitespace();
            identifier = this.parseIdentifier();
            this.parseElement(false);
            if (!this.foundForeachIndexKeyword) {
                throw new TemplateException("Expected 'in'.");
            }
            this.foundForeachIndexKeyword = false;
            variable = this.parseVariable();
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in list statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new ListInstruction(variable, identifier);
    }

    protected IfInstruction parseIfStart() throws TemplateException {
        Expression expression;
        int n = this.parsePos;
        try {
            expression = this.parseExpression(false);
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in if statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new IfInstruction(expression);
    }

    protected AssignInstruction parseAssign() throws TemplateException {
        Expression expression;
        Identifier identifier;
        int n = this.parsePos;
        try {
            this.skipWhitespace();
            identifier = this.parseIdentifier();
            this.skipWhitespace();
            if (this.text.charAt(this.parsePos) == '=') {
                ++this.parsePos;
            }
            expression = this.parseExpression(false);
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in assignment" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new AssignInstruction(identifier, expression);
    }

    protected IncludeInstruction parseInclude() throws TemplateException {
        Expression expression;
        int n = this.parsePos;
        try {
            expression = this.parseExpression(false);
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in include statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new IncludeInstruction(this.template, expression);
    }

    protected SwitchInstruction parseSwitch() throws TemplateException {
        Variable variable;
        int n = this.parsePos;
        try {
            variable = this.parseVariable();
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in switch statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new SwitchInstruction(variable);
    }

    protected CaseInstruction parseCase() throws TemplateException {
        Expression expression;
        int n = this.parsePos;
        try {
            expression = this.parseExpression(false);
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in case statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new CaseInstruction(expression);
    }

    protected CaseInstruction parseDefault() throws TemplateException {
        CaseInstruction caseInstruction = new CaseInstruction();
        caseInstruction.setIsDefault(true);
        return caseInstruction;
    }

    protected FunctionInstruction parseFunction() throws TemplateException {
        String string;
        int n = this.parsePos;
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            this.skipWhitespace();
            string = this.parseIdentifierAsString();
            this.requireChar('(');
            while (!this.skipChar(')')) {
                this.skipWhitespace();
                linkedList.add(this.parseIdentifierAsString());
                this.skipChar(',');
            }
        }
        catch (TemplateException templateException) {
            String string2 = "Syntax error in function declaration" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string2);
        }
        return new FunctionInstruction(string, linkedList);
    }

    protected MethodCall parseMethodCall() throws TemplateException {
        int n = this.parsePos;
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        try {
            while (!this.skipChar(')')) {
                this.skipWhitespace();
                linkedList.add(this.parseExpression(true));
                this.skipChar(',');
            }
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in MethodCall statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new MethodCall(linkedList);
    }

    protected CallInstruction parseFunctionCall() throws TemplateException {
        String string;
        int n = this.parsePos;
        LinkedList<Expression> linkedList = new LinkedList<Expression>();
        try {
            this.skipWhitespace();
            string = this.parseIdentifierAsString();
            this.requireChar('(');
            while (!this.skipChar(')')) {
                this.skipWhitespace();
                linkedList.add(this.parseExpression(true));
                this.skipChar(',');
            }
        }
        catch (TemplateException templateException) {
            String string2 = "Syntax error in call statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string2);
        }
        return new CallInstruction(this.template, string, linkedList);
    }

    protected CommentInstruction parseComment() throws TemplateException {
        int n = this.parsePos;
        try {
            Expression expression = this.parseExpression(false);
            return new CommentInstruction(expression);
        }
        catch (TemplateException templateException) {
            return new CommentInstruction();
        }
    }

    protected NoParseInstruction parseNoparseStart() throws TemplateException {
        return new NoParseInstruction();
    }

    protected TransformInstruction parseTransformStart() throws TemplateException {
        Variable variable;
        int n = this.parsePos;
        try {
            this.skipWhitespace();
            variable = this.parseVariable();
        }
        catch (TemplateException templateException) {
            String string = "Syntax error in transform statement" + this.atChar(n) + this.finishErrorMessage(templateException);
            throw new TemplateException(string);
        }
        return new TransformInstruction(variable);
    }

    protected boolean skipChar(char c) throws TemplateException {
        this.skipWhitespace();
        if (this.text.charAt(this.parsePos) == c) {
            ++this.parsePos;
            return true;
        }
        return false;
    }

    protected void requireChar(char c) throws TemplateException {
        if (!this.skipChar(c)) {
            throw new TemplateException();
        }
    }

    protected void skipWhitespace() throws TemplateException {
        while (this.parsePos < this.textLen && Character.isWhitespace(this.text.charAt(this.parsePos))) {
            ++this.parsePos;
        }
        if (this.parsePos < this.textLen) {
            return;
        }
        throw new TemplateException("Unexpected end of file.");
    }

    protected String finishErrorMessage(Exception exception) {
        if (exception.getMessage() != null) {
            return ": " + exception.getMessage();
        }
        return ".";
    }

    protected boolean isIdentifierChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    protected boolean isIdentifierStartChar(char c) {
        return Character.isLetter(c);
    }

    private abstract class LongOperator {
        private LongOperator() {
        }

        abstract Expression parse() throws TemplateException;
    }

    private abstract class Tag {
        private Tag() {
        }

        abstract Instruction parse() throws TemplateException;
    }
}

