/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.compiler;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateProcessor;
import freemarker.template.compiler.RuntimeStructuralElement;
import freemarker.template.compiler.TemplateBuilder;
import freemarker.template.compiler.TemplateLink;
import freemarker.template.compiler.TemplateLinkedList;
import freemarker.template.compiler.TemplateParser;
import freemarker.template.instruction.CaseInstruction;
import freemarker.template.instruction.EmptyInstruction;
import freemarker.template.instruction.FunctionInstruction;
import freemarker.template.instruction.GenericStartInstruction;
import freemarker.template.instruction.IfInstruction;
import freemarker.template.instruction.Instruction;
import freemarker.template.instruction.NOOPInstruction;
import freemarker.template.instruction.SwitchInstruction;
import freemarker.template.instruction.TextBlockInstruction;
import freemarker.template.instruction.UnparsedInstruction;

public class LinkedListTemplateBuilder
extends TemplateBuilder {
    private TemplateLink head;
    private TemplateParser parser;

    public LinkedListTemplateBuilder(Template template) {
        super(template);
    }

    public LinkedListTemplateBuilder(Template template, TemplateParser templateParser) {
        super(template);
        this.setParser(templateParser);
    }

    public void setParser(TemplateParser templateParser) {
        this.parser = templateParser;
    }

    public TemplateProcessor build() {
        TemplateLinkedList templateLinkedList = new TemplateLinkedList();
        try {
            Instruction instruction = this.buildLinks(templateLinkedList);
            if (instruction != null) {
                throw new TemplateException("Unexpected instruction" + this.parser.atChar(this.parser.getFoundPos()) + ".");
            }
        }
        catch (TemplateException templateException) {
            TextBlockInstruction textBlockInstruction = new TextBlockInstruction();
            textBlockInstruction.setText(Template.formatErrorMessage(templateException.getMessage()));
            return textBlockInstruction;
        }
        return templateLinkedList;
    }

    private Instruction buildLinks(TemplateLinkedList templateLinkedList) throws TemplateException {
        Instruction instruction = null;
        do {
            TextBlockInstruction textBlockInstruction;
            TemplateLink templateLink = new TemplateLink();
            templateLinkedList.add(templateLink);
            instruction = this.parser.getNextInstruction();
            if (instruction == null) {
                textBlockInstruction = new TextBlockInstruction();
                textBlockInstruction.setText(this.parser.getRemainingText());
                templateLink.setStatement(textBlockInstruction);
                return null;
            }
            if (this.parser.hasTextBefore()) {
                textBlockInstruction = new TextBlockInstruction();
                textBlockInstruction.setText(this.parser.getTextBefore());
                templateLink.setStatement(textBlockInstruction);
            }
            if (instruction.isEndInstruction()) {
                return instruction;
            }
            if (templateLink.getStatement() != null) {
                templateLink = new TemplateLink();
                templateLinkedList.add(templateLink);
            }
            instruction.callBuilder(this, templateLink);
        } while (this.parser.hasMoreText());
        return null;
    }

    public void buildStatement(EmptyInstruction emptyInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        runtimeStructuralElement.setStatement(emptyInstruction);
    }

    public void buildStatement(GenericStartInstruction genericStartInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        this.buildGenericBody(genericStartInstruction);
        runtimeStructuralElement.setStatement(genericStartInstruction);
    }

    public void buildStatement(FunctionInstruction functionInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        runtimeStructuralElement.setStatement(new NOOPInstruction());
        this.buildGenericBody(functionInstruction);
        this.template.addFunction(functionInstruction);
    }

    private void buildGenericBody(GenericStartInstruction genericStartInstruction) throws TemplateException {
        int n = this.parser.getFoundPos();
        TemplateLinkedList templateLinkedList = new TemplateLinkedList();
        Instruction instruction = null;
        instruction = this.buildLinks(templateLinkedList);
        genericStartInstruction.setBody(templateLinkedList);
        if (instruction == null || !genericStartInstruction.testEndInstruction(instruction)) {
            throw new TemplateException("Expected end instruction for " + genericStartInstruction.getTypeName() + this.parser.atChar(n) + ".");
        }
    }

    public void buildStatement(IfInstruction ifInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        int n = this.parser.getFoundPos();
        TemplateLinkedList templateLinkedList = new TemplateLinkedList();
        Instruction instruction = this.buildLinks(templateLinkedList);
        ifInstruction.setIfBlock(templateLinkedList);
        if (instruction == null) {
            throw new TemplateException("Expected end of if statement" + this.parser.atChar(n) + ".");
        }
        switch (instruction.getEndType()) {
            case 5: {
                break;
            }
            case 3: {
                TemplateLinkedList templateLinkedList2 = new TemplateLinkedList();
                Instruction instruction2 = this.buildLinks(templateLinkedList2);
                if (instruction2 != null && instruction2.getEndType() == 5) {
                    ifInstruction.setElseBlock(templateLinkedList2);
                    break;
                }
                throw new TemplateException("Expected end of else block for if statement" + this.parser.atChar(n) + ".");
            }
            default: {
                throw new TemplateException("Expected end of if statement" + this.parser.atChar(n) + ".");
            }
        }
        runtimeStructuralElement.setStatement(ifInstruction);
    }

    public void buildStatement(SwitchInstruction switchInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        int n = this.parser.getFoundPos();
        CaseInstruction caseInstruction = null;
        int n2 = -1;
        while (true) {
            TemplateLinkedList templateLinkedList;
            Instruction instruction;
            if ((instruction = this.buildLinks(templateLinkedList = new TemplateLinkedList())) == null) {
                throw new TemplateException("Expected end of switch structure" + this.parser.atChar(n) + ".");
            }
            if (n2 == 1) {
                caseInstruction.setBody(templateLinkedList);
                switchInstruction.addCase(caseInstruction);
            }
            int n3 = instruction.getEndType();
            switch (n3) {
                case 1: {
                    caseInstruction = (CaseInstruction)instruction;
                    break;
                }
                case 0: {
                    if (n2 == 1) {
                        caseInstruction.setHasBreak(true);
                        break;
                    }
                    throw new TemplateException("Unexpected break" + this.parser.atChar(this.parser.getFoundPos()) + ".");
                }
                case 7: {
                    runtimeStructuralElement.setStatement(switchInstruction);
                    return;
                }
                default: {
                    throw new TemplateException("Unexpected instruction" + this.parser.atChar(this.parser.getFoundPos()) + ".");
                }
            }
            n2 = n3;
        }
    }

    public void buildStatement(UnparsedInstruction unparsedInstruction, RuntimeStructuralElement runtimeStructuralElement) throws TemplateException {
        int n = this.parser.getFoundPos();
        boolean bl = this.parser.skipToEndInstruction(unparsedInstruction);
        if (!bl) {
            throw new TemplateException("Expected end instruction for " + unparsedInstruction.getTypeName() + this.parser.atChar(n) + ".");
        }
        unparsedInstruction.setText(this.parser.getTextBefore());
        runtimeStructuralElement.setStatement(unparsedInstruction);
    }
}

