/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.SimpleHash;
import freemarker.template.TemplateCache;
import freemarker.template.TemplateModelRoot;
import freemarker.template.TemplateProcessor;
import freemarker.template.compiler.LinkedListTemplateBuilder;
import freemarker.template.compiler.StandardTemplateParser;
import freemarker.template.instruction.FunctionInstruction;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Template
implements TemplateProcessor {
    protected static final String COMMENT_START = "<!-- ";
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COMMENT_END = " -->" + LINE_SEPARATOR;
    protected TemplateProcessor compiledTemplate;
    protected TemplateCache cache;
    protected Map functions = new HashMap();

    public Template() {
    }

    public Template(String string) throws IOException {
        this.compileFromFile(string);
    }

    public Template(File file) throws IOException {
        this.compileFromFile(file);
    }

    public Template(InputStream inputStream) throws IOException {
        this.compileFromStream(inputStream);
    }

    public Template(Reader reader) throws IOException {
        this.compileFromStream(reader);
    }

    public synchronized void compileFromFile(String string) throws IOException {
        File file = new File(string);
        this.compileFromFile(file);
    }

    public synchronized void compileFromFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Template file " + file.getName() + " not found.");
        }
        if (!file.canRead()) {
            throw new IOException("Can't read from template file " + file.getName() + ".");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.compileFromStream(fileInputStream);
        fileInputStream.close();
    }

    public synchronized void compileFromStream(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        this.compileFromStream(inputStreamReader);
        inputStreamReader.close();
    }

    public synchronized void compileFromStream(Reader reader) throws IOException {
        if (this.compiledTemplate != null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append(LINE_SEPARATOR);
            }
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        bufferedReader.close();
        this.compiledTemplate = this.compileText(stringBuffer.toString());
    }

    protected synchronized TemplateProcessor compileText(String string) {
        StandardTemplateParser standardTemplateParser = new StandardTemplateParser(this, string);
        LinkedListTemplateBuilder linkedListTemplateBuilder = new LinkedListTemplateBuilder(this, standardTemplateParser);
        return linkedListTemplateBuilder.build();
    }

    public void setTemplateCache(TemplateCache templateCache) {
        this.cache = templateCache;
    }

    public TemplateCache getTemplateCache() {
        return this.cache;
    }

    public void addFunction(FunctionInstruction functionInstruction) {
        this.functions.put(functionInstruction.getName(), functionInstruction);
    }

    public FunctionInstruction getFunction(String string) {
        return (FunctionInstruction)this.functions.get(string);
    }

    public Set getFunctionNames() {
        return this.functions.keySet();
    }

    public void process(TemplateModelRoot templateModelRoot, PrintWriter printWriter) {
        if (this.compiledTemplate != null) {
            if (templateModelRoot == null) {
                templateModelRoot = new SimpleHash();
            }
            this.compiledTemplate.process(templateModelRoot, printWriter);
        }
    }

    public void process(PrintWriter printWriter) {
        SimpleHash simpleHash = new SimpleHash();
        this.process(simpleHash, printWriter);
    }

    public static String formatErrorMessage(String string) {
        return "<!-- Template Error: " + string + COMMENT_END;
    }

    public static String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

