/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateListModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

public class SimpleList
implements TemplateListModel,
Serializable {
    private static final int MS_PER_MINUTE = 60000;
    private LinkedList list = new LinkedList();
    private transient ListIterator iterator;
    private long timeCreated;
    private long shelfLife;
    private boolean isPermanent = true;
    private TemplateModelException copyException;

    public SimpleList() {
    }

    public SimpleList(LinkedList linkedList) {
        this.list = linkedList;
    }

    public SimpleList(TemplateModel[] templateModelArray) {
        int n = 0;
        while (n < templateModelArray.length) {
            this.list.add(templateModelArray[n]);
            ++n;
        }
    }

    public SimpleList(TemplateListModel templateListModel) {
        this.copy(templateListModel);
    }

    public synchronized void clear() {
        this.iterator = null;
        this.list.clear();
    }

    public synchronized void setShelfLife(int n) {
        this.isPermanent = false;
        this.shelfLife = n * 60000;
        this.setTimeCreated();
    }

    public synchronized int getShelfLife() {
        return (int)(this.shelfLife / 60000L);
    }

    public synchronized void setPermanent() {
        this.isPermanent = true;
    }

    public synchronized boolean isPermanent() {
        return this.isPermanent;
    }

    public synchronized boolean isStale() {
        return !this.isPermanent && new Date().getTime() - this.timeCreated >= this.shelfLife;
    }

    private synchronized void setTimeCreated() {
        this.timeCreated = new Date().getTime();
    }

    public synchronized void copy(TemplateListModel templateListModel) {
        this.setTimeCreated();
        this.clear();
        this.copyException = null;
        try {
            if (!templateListModel.isRewound()) {
                templateListModel.rewind();
            }
            while (templateListModel.hasNext()) {
                this.list.add(templateListModel.next());
            }
        }
        catch (TemplateModelException templateModelException) {
            this.copyException = templateModelException;
        }
    }

    public synchronized boolean isEmpty() throws TemplateModelException {
        return this.list.isEmpty();
    }

    public synchronized boolean isRewound() throws TemplateModelException {
        return this.iterator == null;
    }

    public synchronized void add(TemplateModel templateModel) {
        this.iterator = null;
        this.list.add(templateModel);
    }

    public synchronized void add(String string) {
        this.add(new SimpleScalar(string));
    }

    public synchronized void add(boolean bl) {
        this.add(new SimpleScalar(bl));
    }

    private synchronized void checkIterator() {
        if (this.iterator == null) {
            this.iterator = this.list.listIterator();
        }
    }

    public synchronized boolean hasNext() throws TemplateModelException {
        this.checkIterator();
        return this.iterator.hasNext();
    }

    public synchronized TemplateModel next() throws TemplateModelException {
        if (this.copyException != null) {
            throw this.copyException;
        }
        this.checkIterator();
        if (this.iterator.hasNext()) {
            return (TemplateModel)this.iterator.next();
        }
        throw new TemplateModelException("No more elements.");
    }

    public synchronized void rewind() throws TemplateModelException {
        this.iterator = null;
    }

    public synchronized TemplateModel listSize() throws TemplateModelException {
        return new SimpleScalar("" + this.list.size());
    }

    public synchronized TemplateModel get(int n) throws TemplateModelException {
        if (n >= this.list.size()) {
            throw new TemplateModelException("IndexOutOfBounds(" + n + ")");
        }
        return (TemplateModel)this.list.get(n);
    }
}

