/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.CacheElement;
import freemarker.template.CacheEvent;
import freemarker.template.CacheListener;
import freemarker.template.GenericEventMulticaster;
import freemarker.template.ListenerAdapter;
import freemarker.template.Template;
import freemarker.template.TemplateCache;
import freemarker.template.Updatable;
import freemarker.template.UpdateTimer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileTemplateCache
implements TemplateCache,
Updatable {
    public static final int LOAD_ON_DEMAND = 0;
    public static final int PRELOAD = 1;
    public static final int LOAD_AD_HOC = 2;
    protected File cacheDir;
    private Map cache = new HashMap();
    private UpdateTimer timer;
    private long delay = 5000L;
    private int loadingPolicy = 0;
    private GenericEventMulticaster multicaster = new GenericEventMulticaster();
    private String encoding;
    private String filenameSuffix;
    private ListenerAdapter unavailableAdapter = new ListenerAdapter(){

        public void fireEvent(EventObject eventObject, EventListener eventListener) {
            ((CacheListener)eventListener).cacheUnavailable((CacheEvent)eventObject);
        }
    };
    private ListenerAdapter updatedAdapter = new ListenerAdapter(){

        public void fireEvent(EventObject eventObject, EventListener eventListener) {
            ((CacheListener)eventListener).elementUpdated((CacheEvent)eventObject);
        }
    };
    private ListenerAdapter updateFailedAdapter = new ListenerAdapter(){

        public void fireEvent(EventObject eventObject, EventListener eventListener) {
            ((CacheListener)eventListener).elementUpdateFailed((CacheEvent)eventObject);
        }
    };
    private ListenerAdapter removedAdapter = new ListenerAdapter(){

        public void fireEvent(EventObject eventObject, EventListener eventListener) {
            ((CacheListener)eventListener).elementRemoved((CacheEvent)eventObject);
        }
    };

    public FileTemplateCache() {
    }

    public FileTemplateCache(String string) {
        this.setPath(string);
    }

    public FileTemplateCache(File file) {
        this.setDirectory(file);
    }

    public FileTemplateCache(String string, long l) {
        this(string);
        this.setDelay(l);
    }

    public FileTemplateCache(File file, long l) {
        this(file);
        this.setDelay(l);
    }

    public int getLoadingPolicy() {
        return this.loadingPolicy;
    }

    public void setLoadingPolicy(int n) {
        this.loadingPolicy = n;
        switch (n) {
            case 2: {
                this.stopAutoUpdate();
                this.loadTemplates();
                break;
            }
            case 1: {
                this.startAutoUpdate();
                break;
            }
            case 0: {
                this.removeTemplates();
                this.startAutoUpdate();
            }
        }
    }

    public void setPath(String string) {
        this.setDirectory(new File(string));
    }

    public String getPath() {
        return this.cacheDir.toString();
    }

    public synchronized void setDirectory(File file) {
        this.removeTemplates();
        this.cacheDir = file;
    }

    public File getDirectory() {
        return this.cacheDir;
    }

    public synchronized void setDelay(long l) {
        this.delay = l * 1000L;
    }

    public long getDelay() {
        return this.delay / 1000L;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setFilenameSuffix(String string) {
        this.filenameSuffix = string;
    }

    public String getFilenameSuffix() {
        return this.filenameSuffix;
    }

    public void addCacheListener(CacheListener cacheListener) {
        this.multicaster.addListener(cacheListener);
    }

    public void removeCacheListener(CacheListener cacheListener) {
        this.multicaster.removeListener(cacheListener);
    }

    public synchronized Template getTemplate(String string) {
        if (this.filenameSuffix != null && !string.endsWith(this.filenameSuffix)) {
            this.fireCacheEvent(this.updateFailedAdapter, string, new IOException("The requested name, \"" + string + "\", does not have the filename suffix \"" + this.filenameSuffix + "\"."));
            return null;
        }
        switch (this.loadingPolicy) {
            case 1: 
            case 2: {
                CacheElement cacheElement = (CacheElement)this.cache.get(string);
                return cacheElement != null ? (Template)cacheElement.object : null;
            }
            case 0: {
                if (!this.checkCacheDir()) break;
                return this.doUpdate(string);
            }
        }
        return null;
    }

    public void startAutoUpdate() {
        if (this.loadingPolicy != 2) {
            FileTemplateCache fileTemplateCache = this;
            synchronized (fileTemplateCache) {
                this.stopAutoUpdate();
                if (this.timer == null) {
                    this.timer = new UpdateTimer(this, this.delay);
                }
                this.update();
                this.timer.startTiming();
            }
        }
    }

    public void stopAutoUpdate() {
        if (this.timer != null) {
            this.timer.stopTiming();
            this.timer = null;
        }
    }

    public Iterator listCachedFiles() {
        return Collections.unmodifiableCollection(this.cache.values()).iterator();
    }

    private boolean checkCacheDir() {
        if (!this.cacheDir.exists()) {
            this.fireCacheEvent(this.unavailableAdapter, null, new IOException("Directory \"" + this.cacheDir.getAbsolutePath() + "\" not found."));
            this.stopAutoUpdate();
            return false;
        }
        if (!this.cacheDir.isDirectory()) {
            this.fireCacheEvent(this.unavailableAdapter, null, new IOException("\"" + this.cacheDir.getAbsolutePath() + "\" is not a directory."));
            this.stopAutoUpdate();
            return false;
        }
        return true;
    }

    private Template loadTemplate(File file) throws IOException {
        if (this.encoding == null) {
            return new Template(file);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.encoding);
        Template template = new Template(inputStreamReader);
        inputStreamReader.close();
        fileInputStream.close();
        return template;
    }

    private Template getLatestTemplate(String string, File file) {
        Template template = null;
        long l = file.lastModified();
        CacheElement cacheElement = (CacheElement)this.cache.get(string);
        try {
            if (cacheElement == null) {
                template = this.loadTemplate(file);
                template.setTemplateCache(this);
                this.cache.put(string, new CacheElement(string, template, l));
                this.fireCacheEvent(this.updatedAdapter, string, null);
            } else if (l > cacheElement.lastModified) {
                template = this.loadTemplate(file);
                template.setTemplateCache(this);
                cacheElement.object = template;
                cacheElement.lastModified = l;
                this.fireCacheEvent(this.updatedAdapter, string, null);
            } else {
                template = (Template)cacheElement.object;
            }
        }
        catch (IOException iOException) {
            this.fireCacheEvent(this.updateFailedAdapter, string, iOException);
        }
        return template;
    }

    public synchronized void update(String string) {
        if (this.loadingPolicy == 2 && this.checkCacheDir()) {
            this.doUpdate(string);
        }
    }

    private Template doUpdate(String string) {
        File file = this.nameToFile(string);
        if (!file.exists()) {
            this.removeTemplate(string);
            this.fireCacheEvent(this.updateFailedAdapter, string, new IOException("\"" + file.getPath() + "\" doesn't exist"));
            return null;
        }
        if (!file.isFile()) {
            this.fireCacheEvent(this.updateFailedAdapter, string, new IOException("\"" + file.getAbsolutePath() + "\" is a directory"));
            return null;
        }
        return this.getLatestTemplate(string, file);
    }

    public synchronized void update() {
        if (!this.checkCacheDir()) {
            return;
        }
        switch (this.loadingPolicy) {
            case 2: {
                break;
            }
            case 0: {
                this.removeDeletedTemplates();
                break;
            }
            case 1: {
                this.loadTemplates();
                break;
            }
        }
    }

    private void loadTemplates() {
        LinkedList linkedList = new LinkedList();
        try {
            this.readDirectory(this.cacheDir, "", linkedList);
            this.removeUnvisitedTemplates(linkedList);
        }
        catch (IOException iOException) {
            this.stopAutoUpdate();
            this.fireCacheEvent(this.unavailableAdapter, null, iOException);
            return;
        }
    }

    private void removeTemplates() {
        this.cache.clear();
    }

    private void removeUnvisitedTemplates(LinkedList linkedList) {
        Set set = this.cache.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (linkedList.contains(string)) continue;
            iterator.remove();
            this.fireCacheEvent(this.removedAdapter, string, null);
        }
    }

    private void removeDeletedTemplates() {
        Set set = this.cache.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file = this.nameToFile(string);
            if (file.exists()) continue;
            iterator.remove();
            this.fireCacheEvent(this.removedAdapter, string, null);
        }
    }

    private void removeTemplate(String string) {
        this.cache.remove(string);
        this.fireCacheEvent(this.removedAdapter, string, null);
    }

    private void readDirectory(File file, String string, List list) throws IOException {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException("Could not get file list from directory \"" + file.getAbsolutePath() + "\".");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            File file2 = new File(file, string2);
            String string3 = string + string2;
            if (file2.isFile()) {
                if (this.filenameSuffix == null || string2.endsWith(this.filenameSuffix)) {
                    list.add(string3);
                    this.getLatestTemplate(string3, file2);
                }
            } else if (file2.isDirectory()) {
                this.readDirectory(file2, string3 + "/", list);
            }
            ++n;
        }
    }

    private File nameToFile(String string) {
        if (File.separatorChar == '/') {
            return new File(this.cacheDir, string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '/') {
                stringBuffer.append(File.separatorChar);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return new File(this.cacheDir, stringBuffer.toString());
    }

    private void fireCacheEvent(ListenerAdapter listenerAdapter, String string, Exception exception) {
        CacheEvent cacheEvent = new CacheEvent(this);
        cacheEvent.setElementName(string);
        cacheEvent.setException(exception);
        this.multicaster.fireEvent(cacheEvent, listenerAdapter);
    }
}

