/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.BinaryCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class BinaryData {
    private byte[] dataarray = null;
    private BinaryCache cache;
    private Map functions = new HashMap();

    public BinaryData() {
    }

    public BinaryData(String string) throws IOException {
        this.compileFromFile(string);
    }

    public BinaryData(File file) throws IOException {
        this.compileFromFile(file);
    }

    public BinaryData(InputStream inputStream) throws IOException {
        this.compileFromStream(inputStream);
    }

    public synchronized void compileFromFile(String string) throws IOException {
        File file = new File(string);
        this.compileFromFile(file);
    }

    public synchronized void compileFromFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Template file " + file.getName() + " not found.");
        }
        if (!file.canRead()) {
            throw new IOException("Can't read from template file " + file.getName() + ".");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.compileFromStream(fileInputStream);
        fileInputStream.close();
    }

    public synchronized void compileFromStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        this.dataarray = byteArrayOutputStream.toByteArray();
    }

    public void setBinaryCache(BinaryCache binaryCache) {
        this.cache = binaryCache;
    }

    public BinaryCache getBinaryCache() {
        return this.cache;
    }

    public void process(OutputStream outputStream) {
        try {
            if (this.dataarray != null) {
                outputStream.write(this.dataarray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String formatErrorMessage(String string) {
        return "BinaryData Error: " + string;
    }

    public static String getStackTrace(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

