/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.servlet;

import freemarker.template.FileTemplateCache;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateCache;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelRoot;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.szegedi.expose.servlet.HttpRequestHashModel;
import org.szegedi.expose.servlet.HttpRequestParametersHashModel;
import org.szegedi.expose.servlet.HttpSessionHashModel;
import org.szegedi.expose.servlet.ServletContextHashModel;

public class ExposeServlet
extends HttpServlet {
    public static final long serialVersionUID = -2440216393145762479L;
    private static final String INITPARAM_TEMPLATE_PATH = "TemplatePath";
    private static final String INITPARAM_TEMPLATE_PATH_DEFAULT = "/";
    private static final String INITPARAM_TEMPLATE_DELAY = "TemplateUpdateInterval";
    private static final String INITPARAM_TEMPLATE_DELAY_DEFAULT = "60000";
    private static final String INITPARAM_NOCACHE = "NoCache";
    private static final String KEY_REQUEST = "Request";
    private static final String KEY_REQUEST_PARAMETERS = "RequestParameters";
    private static final String KEY_SESSION = "Session";
    private static final String KEY_APPLICATION = "Application";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    private static final String ATTR_SESSION_MODEL = ".freemarker.Session";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String EXPIRATION_DATE;
    private TemplateCache cache;
    private boolean nocache;
    protected boolean debug;

    public void init() {
        this.cache = this.createCache();
        String string = this.getServletConfig().getInitParameter(INITPARAM_NOCACHE);
        this.nocache = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
        String string2 = this.getServletConfig().getInitParameter("debug");
        this.debug = "true".equalsIgnoreCase(string2) || "yes".equalsIgnoreCase(string2);
    }

    protected TemplateCache createCache() {
        String string = this.getServletConfig().getInitParameter(INITPARAM_TEMPLATE_PATH);
        String string2 = this.getServletConfig().getInitParameter(INITPARAM_TEMPLATE_DELAY);
        if (string == null) {
            string = INITPARAM_TEMPLATE_PATH_DEFAULT;
        }
        long l = 600000L;
        try {
            if (string2 != null) {
                l = Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = string.startsWith("file://") ? string.substring(7) : this.getServletContext().getRealPath(string);
        if (this.debug) {
            System.err.println("TemplatePath: " + string);
        }
        return new FileTemplateCache(string, l);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.process(httpServletRequest, httpServletResponse);
    }

    private void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Template template;
        String string = httpServletRequest.getPathInfo();
        if (string == null) {
            string = "";
        }
        if (this.debug) {
            System.err.println("Requested template: " + string);
        }
        if ((template = this.cache.getTemplate(string)) == null) {
            httpServletResponse.sendError(404);
            return;
        }
        this.setBrowserCachingPolicy(httpServletResponse);
        SimpleHash simpleHash = new SimpleHash();
        ServletContext servletContext = this.getServletContext();
        ServletContextHashModel servletContextHashModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
        if (servletContextHashModel == null) {
            servletContextHashModel = new ServletContextHashModel(servletContext);
            servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextHashModel);
            this.initializeServletContext(httpServletRequest, httpServletResponse);
        }
        simpleHash.put(KEY_APPLICATION, (TemplateModel)servletContextHashModel);
        HttpSession httpSession = httpServletRequest.getSession();
        HttpSessionHashModel httpSessionHashModel = (HttpSessionHashModel)httpSession.getAttribute(ATTR_SESSION_MODEL);
        if (httpSessionHashModel == null) {
            httpSessionHashModel = new HttpSessionHashModel(httpSession);
            httpSession.setAttribute(ATTR_SESSION_MODEL, (Object)httpSessionHashModel);
            this.initializeSession(httpServletRequest, httpServletResponse);
        }
        simpleHash.put(KEY_SESSION, (TemplateModel)httpSessionHashModel);
        HttpRequestHashModel httpRequestHashModel = (HttpRequestHashModel)httpServletRequest.getAttribute(ATTR_REQUEST_MODEL);
        if (httpRequestHashModel == null) {
            httpRequestHashModel = new HttpRequestHashModel(httpServletRequest);
            httpServletRequest.setAttribute(ATTR_REQUEST_MODEL, (Object)httpRequestHashModel);
        }
        simpleHash.put(KEY_REQUEST, (TemplateModel)httpRequestHashModel);
        HttpRequestParametersHashModel httpRequestParametersHashModel = (HttpRequestParametersHashModel)httpServletRequest.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
        if (httpRequestParametersHashModel == null) {
            httpRequestParametersHashModel = this.createRequestParametersHashModel(httpServletRequest);
            httpServletRequest.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, (Object)httpRequestParametersHashModel);
        }
        simpleHash.put(KEY_REQUEST_PARAMETERS, (TemplateModel)httpRequestParametersHashModel);
        if (this.preTemplateProcess(httpServletRequest, httpServletResponse, template, (TemplateModelRoot)simpleHash)) {
            try {
                template.process((TemplateModelRoot)simpleHash, httpServletResponse.getWriter());
                Object var13_12 = null;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                this.postTemplateProcess(httpServletRequest, httpServletResponse, template, (TemplateModelRoot)simpleHash);
                throw throwable;
            }
            this.postTemplateProcess(httpServletRequest, httpServletResponse, template, (TemplateModelRoot)simpleHash);
            {
            }
        }
    }

    protected HttpRequestParametersHashModel createRequestParametersHashModel(HttpServletRequest httpServletRequest) {
        return new HttpRequestParametersHashModel(httpServletRequest);
    }

    protected void initializeServletContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected void initializeSession(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
    }

    protected boolean preTemplateProcess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Template template, TemplateModelRoot templateModelRoot) throws ServletException, IOException {
        return true;
    }

    protected void postTemplateProcess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Template template, TemplateModelRoot templateModelRoot) throws ServletException, IOException {
    }

    private void setBrowserCachingPolicy(HttpServletResponse httpServletResponse) {
        if (this.nocache) {
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            httpServletResponse.setHeader("Expires", EXPIRATION_DATE);
        }
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.roll(1, -1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        EXPIRATION_DATE = simpleDateFormat.format(gregorianCalendar.getTime());
    }
}

