/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.szegedi.expose.model.ReflectionObjectModelBase;
import org.szegedi.expose.model.ReflectionUtilities;

public final class ResourceBundleHashModel
extends ReflectionObjectModelBase
implements TemplateHashModel,
TemplateMethodModel {
    private Hashtable formats = null;

    public ResourceBundleHashModel(ResourceBundle resourceBundle) {
        super(resourceBundle);
    }

    public static final ResourceBundleHashModel getInstance(ResourceBundle resourceBundle) {
        if (ReflectionObjectModelBase.noCache) {
            return new ResourceBundleHashModel(resourceBundle);
        }
        ResourceBundleHashModel resourceBundleHashModel = (ResourceBundleHashModel)ReflectionObjectModelBase.lookup(resourceBundle);
        if (resourceBundleHashModel == null) {
            resourceBundleHashModel = new ResourceBundleHashModel(resourceBundle);
            ReflectionObjectModelBase.register(resourceBundleHashModel, resourceBundle);
        }
        return resourceBundleHashModel;
    }

    public int getType() {
        return 6;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        try {
            return ReflectionUtilities.wrap(((ResourceBundle)this.object).getObject(string), false);
        }
        catch (MissingResourceException missingResourceException) {
            throw new TemplateModelException("No such key: " + string);
        }
    }

    public boolean isEmpty() {
        return !((ResourceBundle)this.object).getKeys().hasMoreElements();
    }

    public TemplateModel exec(List list) throws TemplateModelException {
        if (list.size() < 1) {
            throw new TemplateModelException("No message key was specified");
        }
        Iterator iterator = list.iterator();
        String string = iterator.next().toString();
        int n = list.size() - 1;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        try {
            return new SimpleScalar(this.format(string, objectArray));
        }
        catch (MissingResourceException missingResourceException) {
            throw new TemplateModelException("No such key: " + string);
        }
    }

    public String format(String string, Object[] objectArray) throws MissingResourceException {
        if (this.formats == null) {
            this.formats = new Hashtable();
        }
        MessageFormat messageFormat = null;
        messageFormat = (MessageFormat)this.formats.get(string);
        if (messageFormat == null) {
            messageFormat = new MessageFormat(((ResourceBundle)this.object).getString(string));
            this.formats.put(string, messageFormat);
        }
        return messageFormat.format(objectArray);
    }

    public ResourceBundle getBundle() {
        return (ResourceBundle)this.object;
    }
}

