/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateListModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.util.List;
import org.szegedi.expose.model.ReflectionObjectModelBase;
import org.szegedi.expose.model.ReflectionUtilities;

public final class ReflectionArrayModel
extends ReflectionObjectModelBase
implements TemplateHashModel,
TemplateMethodModel,
TemplateListModel {
    private boolean scalar;
    private ThreadLocal listIndex = new ThreadLocal(){

        protected Object initialValue() {
            return new MutableInteger();
        }
    };

    public ReflectionArrayModel(Object object) {
        super(object);
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Object is not an array, it is " + object.getClass().getName());
        }
        this.scalar = ReflectionUtilities.isScalar(clazz.getComponentType());
    }

    public static final ReflectionArrayModel getInstance(Object object) {
        if (ReflectionObjectModelBase.noCache) {
            return new ReflectionArrayModel(object);
        }
        ReflectionObjectModelBase reflectionObjectModelBase = ReflectionObjectModelBase.lookup(object);
        if (reflectionObjectModelBase instanceof ReflectionArrayModel) {
            return (ReflectionArrayModel)reflectionObjectModelBase;
        }
        ReflectionArrayModel reflectionArrayModel = new ReflectionArrayModel(object);
        ReflectionObjectModelBase.register(reflectionArrayModel, object);
        return reflectionArrayModel;
    }

    public int getType() {
        return 1;
    }

    public TemplateModel get(String string) {
        try {
            return this.get(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("length")) {
                return ReflectionUtilities.wrap(new Integer(Array.getLength(this.object)), true);
            }
            throw numberFormatException;
        }
    }

    public TemplateModel exec(List list) throws TemplateModelException {
        Object e = list.get(0);
        if (e instanceof Number) {
            return this.get(((Number)e).intValue());
        }
        return this.get(Integer.parseInt(e.toString()));
    }

    public TemplateModel get(int n) {
        return ReflectionUtilities.wrap(Array.get(this.object, n), this.scalar);
    }

    public boolean isEmpty() {
        return this.object == null || Array.getLength(this.object) == 0;
    }

    public boolean hasNext() {
        return ((MutableInteger)this.listIndex.get()).i < Array.getLength(this.object);
    }

    public boolean isRewound() {
        return ((MutableInteger)this.listIndex.get()).i == 0;
    }

    public TemplateModel next() {
        return this.get(((MutableInteger)this.listIndex.get()).i++);
    }

    public void rewind() {
        ((MutableInteger)this.listIndex.get()).i = 0;
    }

    public TemplateModel listSize() {
        return new SimpleScalar(Integer.toString(Array.getLength(this.object)));
    }

    private static class MutableInteger {
        int i = 0;

        private MutableInteger() {
        }
    }
}

