/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.szegedi.collection.IdentityHashMap;
import org.szegedi.expose.model.ReflectionMethodModel;
import org.szegedi.expose.model.ReflectionUtilities;

public final class StaticModel
implements TemplateHashModel {
    private static final Map modelCache = new IdentityHashMap();
    private static final ReferenceQueue refQueue = new ReferenceQueue();
    private Class clazz;
    private final Map map = new HashMap();

    private StaticModel(Class clazz) {
        this.clazz = clazz;
        this.populate();
    }

    public static final StaticModel create(Class clazz) {
        StaticModel staticModel = null;
        ModelReference modelReference = null;
        Map map = modelCache;
        synchronized (map) {
            modelReference = (ModelReference)modelCache.get(clazz);
        }
        if (modelReference != null && (staticModel = modelReference.getModel()) != null) {
            return staticModel;
        }
        staticModel = new StaticModel(clazz);
        Map map2 = modelCache;
        synchronized (map2) {
            ModelReference modelReference2;
            while ((modelReference2 = (ModelReference)refQueue.poll()) != null) {
                modelCache.remove(modelReference2.clazz);
            }
            modelCache.put(clazz, new ModelReference(staticModel));
        }
        return staticModel;
    }

    public TemplateModel get(String string) throws TemplateModelException {
        Object v = this.map.get(string);
        if (v instanceof TemplateModel) {
            return (TemplateModel)v;
        }
        if (v instanceof Field) {
            try {
                return ReflectionUtilities.wrap(((Field)v).get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TemplateModelException("Illegal access for field " + string + " of class " + this.clazz.getName());
            }
        }
        throw new TemplateModelException("No such key: " + string + " in class " + this.clazz.getName());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private void populate() {
        int n;
        Object object;
        Field[] fieldArray = this.clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            object = fieldArray[n2];
            n = ((Field)object).getModifiers();
            if (Modifier.isPublic(n) && Modifier.isStatic(n)) {
                if (Modifier.isFinal(n)) {
                    try {
                        this.map.put(((Field)object).getName(), ReflectionUtilities.wrap(((Field)object).get(null)));
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                } else {
                    this.map.put(((Field)object).getName(), object);
                }
            }
            ++n2;
        }
        object = this.clazz.getMethods();
        n = 0;
        while (n < ((Object)object).length) {
            Object object2 = object[n];
            int n3 = ((Method)object2).getModifiers();
            if (Modifier.isPublic(n3) && Modifier.isStatic(n3)) {
                try {
                    object2 = ReflectionUtilities.getPublicMethod((Method)object2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                this.map.put(((Method)object2).getName(), new ReflectionMethodModel(null, (Method)object2));
            }
            ++n;
        }
    }

    private static final class ModelReference
    extends WeakReference {
        Class clazz;

        ModelReference(StaticModel staticModel) {
            super(staticModel, refQueue);
            this.clazz = staticModel.clazz;
        }

        StaticModel getModel() {
            return (StaticModel)this.get();
        }
    }
}

