/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.szegedi.expose.model.BooleanScalar;
import org.szegedi.expose.model.Models;
import org.szegedi.expose.model.ReflectionArrayModel;
import org.szegedi.expose.model.ReflectionCollectionModel;
import org.szegedi.expose.model.ReflectionEnumerationModel;
import org.szegedi.expose.model.ReflectionIteratorModel;
import org.szegedi.expose.model.ReflectionMapModel;
import org.szegedi.expose.model.ReflectionObjectModel;
import org.szegedi.expose.model.ReflectionObjectModelBase;
import org.szegedi.expose.model.ReflectionScalarModel;

public final class ReflectionUtilities {
    private static final Map publicMethodCache = new WeakHashMap();
    public static final boolean WRAP_AS_SCALAR = true;
    public static final boolean WRAP_AS_OBJECT = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    private ReflectionUtilities() {
    }

    public static final boolean isScalar(Class clazz) {
        return clazz.isPrimitive() || clazz == (class$java$lang$String == null ? (class$java$lang$String = ReflectionUtilities.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtilities.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public static final boolean isScalar(Object object) {
        return object == null || ReflectionUtilities.isScalar(object.getClass());
    }

    public static final TemplateModel wrap(Object object) {
        return ReflectionUtilities.wrap(object, ReflectionUtilities.isScalar(object));
    }

    public static final TemplateModel wrap(Object object, boolean bl) {
        if (object != null) {
            if (bl) {
                if (object instanceof Boolean) {
                    return BooleanScalar.getScalar((boolean)((Boolean)object));
                }
                return new SimpleScalar(object.toString());
            }
            if (object instanceof TemplateModel) {
                return (TemplateModel)object;
            }
            if (object.getClass().isArray()) {
                return ReflectionArrayModel.getInstance(object);
            }
            if (object instanceof String) {
                return ReflectionObjectModelBase.getInstance((String)object);
            }
            if (object instanceof Map) {
                return ReflectionMapModel.getInstance((Map)object);
            }
            if (object instanceof Collection) {
                return ReflectionCollectionModel.getInstance((Collection)object);
            }
            if (object instanceof Iterator) {
                return ReflectionIteratorModel.getInstance((Iterator)object);
            }
            if (object instanceof Enumeration) {
                return ReflectionEnumerationModel.getInstance((Enumeration)object);
            }
            return ReflectionObjectModel.getInstance(object);
        }
        return Models.EMPTY_SCALAR;
    }

    public static final Object unwrap(Object object) throws TemplateModelException {
        if (object instanceof ReflectionObjectModelBase) {
            return ((ReflectionObjectModelBase)object).getObject();
        }
        if (object instanceof ReflectionScalarModel) {
            return ((ReflectionScalarModel)object).getAsObject();
        }
        if (object instanceof BooleanScalar) {
            return BooleanScalar.getBoolean(object) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)object).getAsString();
        }
        return object;
    }

    static final Method getPublicMethod(Method method) throws NoSuchMethodException {
        Class<?> clazz = method.getDeclaringClass();
        if ((clazz.getModifiers() & 1) != 0) {
            return method;
        }
        Map map = publicMethodCache;
        synchronized (map) {
            Method method2 = (Method)publicMethodCache.get(method);
            if (method2 == null) {
                method2 = ReflectionUtilities.getPublicMethod(clazz, method.getName(), method.getParameterTypes());
                publicMethodCache.put(method, method2);
            }
            Method method3 = method2;
            return method3;
        }
    }

    static final Method getPublicMethodOrNull(Method method) {
        if (method == null) {
            return null;
        }
        try {
            return ReflectionUtilities.getPublicMethod(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static final Method getPublicMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        if ((clazz.getModifiers() & 1) != 0) {
            return clazz.getMethod(string, classArray);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            try {
                return ReflectionUtilities.getPublicMethod(clazz2, string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?>[] classArray2 = clazz.getInterfaces();
        int n = 0;
        while (n < classArray2.length) {
            try {
                return ReflectionUtilities.getPublicMethod(classArray2[n], string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                ++n;
            }
        }
        throw new NoSuchMethodException();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

