/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.TemplateScalarModel;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.szegedi.collection.IdentityHashMap;
import org.szegedi.expose.model.ReflectionObjectModel;

public class ReflectionObjectModelBase
implements TemplateScalarModel {
    public static final int TYPE_OBJECT_BASE = -1;
    public static final int TYPE_OBJECT = 0;
    public static final int TYPE_ARRAY = 1;
    public static final int TYPE_COLLECTION = 2;
    public static final int TYPE_MAP = 3;
    public static final int TYPE_ITERATOR = 4;
    public static final int TYPE_ENUMERATION = 5;
    public static final int TYPE_RESOURCE_BUNDLE = 6;
    static final boolean noCache = Boolean.getBoolean("expose.reflection.nocache");
    private static final Map modelCache = noCache ? null : new IdentityHashMap();
    private static final ReferenceQueue refQueue = noCache ? null : new ReferenceQueue();
    Object object;

    ReflectionObjectModelBase(Object object) {
        this.object = object;
    }

    ReflectionObjectModelBase(String string) {
        this.object = string;
    }

    public static final ReflectionObjectModelBase getInstance(String string) {
        if (noCache) {
            return new ReflectionObjectModel((Object)string);
        }
        ReflectionObjectModelBase reflectionObjectModelBase = ReflectionObjectModelBase.lookup(string);
        if (reflectionObjectModelBase == null) {
            reflectionObjectModelBase = new ReflectionObjectModelBase(string);
            ReflectionObjectModelBase.register(reflectionObjectModelBase, string);
        }
        return reflectionObjectModelBase;
    }

    public Object getObject() {
        return this.object;
    }

    static final ReflectionObjectModelBase lookup(Object object) {
        Object var1_1 = null;
        ModelReference modelReference = null;
        Map map = modelCache;
        synchronized (map) {
            modelReference = (ModelReference)modelCache.get(object);
        }
        if (modelReference != null) {
            return modelReference.getModel();
        }
        return null;
    }

    static final void register(ReflectionObjectModelBase reflectionObjectModelBase, Object object) {
        Map map = modelCache;
        synchronized (map) {
            ModelReference modelReference;
            while ((modelReference = (ModelReference)refQueue.poll()) != null) {
                modelCache.remove(modelReference.object);
            }
            modelCache.put(object, new ModelReference(reflectionObjectModelBase));
        }
    }

    public int getType() {
        return -1;
    }

    public String getAsString() {
        return this.object == null ? "null" : this.object.toString();
    }

    public boolean isEmpty() {
        return this.object == null || this.object instanceof Boolean && (Boolean)this.object == false;
    }

    private static String print(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }

    private static final class ModelReference
    extends WeakReference {
        Object object;

        ModelReference(ReflectionObjectModelBase reflectionObjectModelBase) {
            super(reflectionObjectModelBase, refQueue);
            this.object = reflectionObjectModelBase.object;
        }

        ReflectionObjectModelBase getModel() {
            ReflectionObjectModelBase reflectionObjectModelBase = (ReflectionObjectModelBase)this.get();
            return reflectionObjectModelBase;
        }
    }
}

