/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.TemplateListModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.Iterator;
import java.util.ListIterator;
import org.szegedi.expose.model.ReflectionObjectModel;
import org.szegedi.expose.model.ReflectionObjectModelBase;
import org.szegedi.expose.model.ReflectionUtilities;

public final class ReflectionIteratorModel
extends ReflectionObjectModel
implements TemplateListModel {
    private boolean rewound = true;

    public ReflectionIteratorModel(Iterator iterator) {
        super(iterator);
    }

    public static final ReflectionIteratorModel getInstance(Iterator iterator) {
        if (ReflectionObjectModelBase.noCache) {
            return new ReflectionIteratorModel(iterator);
        }
        ReflectionIteratorModel reflectionIteratorModel = (ReflectionIteratorModel)ReflectionObjectModelBase.lookup(iterator);
        if (reflectionIteratorModel == null) {
            reflectionIteratorModel = new ReflectionIteratorModel(iterator);
            ReflectionObjectModelBase.register(reflectionIteratorModel, iterator);
        }
        return reflectionIteratorModel;
    }

    public int getType() {
        return 4;
    }

    public boolean hasNext() {
        return ((Iterator)this.object).hasNext();
    }

    public boolean isRewound() {
        return this.rewound;
    }

    public TemplateModel next() {
        this.rewound = false;
        return ReflectionUtilities.wrap(((Iterator)this.object).next());
    }

    public void rewind() throws TemplateModelException {
        if (!this.rewound) {
            if (this.object instanceof ListIterator) {
                ListIterator listIterator = (ListIterator)this.object;
                while (listIterator.hasPrevious()) {
                    listIterator.previous();
                }
                this.rewound = true;
            } else {
                throw new TemplateModelException("Cannot rewind an Iterator that is not a ListIterator.");
            }
        }
    }

    public boolean isEmpty() {
        return this.object == null || !((Iterator)this.object).hasNext();
    }

    public TemplateModel listSize() {
        throw new UnsupportedOperationException();
    }

    public TemplateModel get(int n) {
        throw new UnsupportedOperationException();
    }
}

