/*
 * Decompiled with CFR 0.152.
 */
package org.szegedi.expose.model;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateListModel;
import freemarker.template.TemplateModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.szegedi.expose.model.ReflectionObjectModel;
import org.szegedi.expose.model.ReflectionObjectModelBase;
import org.szegedi.expose.model.ReflectionUtilities;

public final class ReflectionCollectionModel
extends ReflectionObjectModel
implements TemplateListModel {
    private ThreadLocal iterator = new ThreadLocal();

    public ReflectionCollectionModel(Collection collection) {
        super(collection);
    }

    public static final ReflectionCollectionModel getInstance(Collection collection) {
        if (ReflectionObjectModelBase.noCache) {
            return new ReflectionCollectionModel(collection);
        }
        ReflectionCollectionModel reflectionCollectionModel = (ReflectionCollectionModel)ReflectionObjectModelBase.lookup(collection);
        if (reflectionCollectionModel == null) {
            reflectionCollectionModel = new ReflectionCollectionModel(collection);
            ReflectionObjectModelBase.register(reflectionCollectionModel, collection);
        }
        return reflectionCollectionModel;
    }

    public int getType() {
        return 2;
    }

    public boolean hasNext() {
        boolean bl = ((Iterator)this.iterator.get()).hasNext();
        if (!bl) {
            this.iterator.set(null);
        }
        return bl;
    }

    public boolean isRewound() {
        return false;
    }

    public TemplateModel next() {
        return ReflectionUtilities.wrap(((Iterator)this.iterator.get()).next());
    }

    public void rewind() {
        this.iterator.set(((Collection)this.object).iterator());
    }

    public TemplateModel get(int n) {
        if (this.object instanceof List) {
            return ReflectionUtilities.wrap(((List)this.object).get(n));
        }
        throw new UnsupportedOperationException();
    }

    public TemplateModel listSize() {
        return new SimpleScalar(Integer.toString(((Collection)this.object).size()));
    }

    public boolean isEmpty() {
        return ((Collection)this.object).isEmpty();
    }
}

