/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class ServletUtils {
    public static void returnFile(String filename, OutputStream out) throws FileNotFoundException, IOException {
        FileInputStream fis = null;
        try {
            int bytesRead;
            fis = new FileInputStream(filename);
            byte[] buf = new byte[4096];
            while ((bytesRead = fis.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        finally {
            Object var4_5 = null;
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static void returnURL(URL url, OutputStream out) throws IOException {
        int bytesRead;
        InputStream in = url.openStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf)) != -1) {
            out.write(buf, 0, bytesRead);
        }
    }

    public static void returnURL(URL url, PrintWriter out) throws IOException {
        int charsRead;
        URLConnection con = url.openConnection();
        con.connect();
        String encoding = con.getContentEncoding();
        BufferedReader in = null;
        in = encoding == null ? new BufferedReader(new InputStreamReader(url.openStream())) : new BufferedReader(new InputStreamReader(url.openStream(), encoding));
        char[] buf = new char[4096];
        while ((charsRead = in.read(buf)) != -1) {
            out.write(buf, 0, charsRead);
        }
    }

    public static String getStackTraceAsString(Exception e) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes, true);
        e.printStackTrace(writer);
        return bytes.toString();
    }

    public static Servlet getServlet(String name, ServletRequest req, ServletContext context) {
        try {
            Servlet servlet = context.getServlet(name);
            if (servlet != null) {
                return servlet;
            }
            Socket socket = new Socket(req.getServerName(), req.getServerPort());
            socket.setSoTimeout(4000);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println("GET /servlet/" + name + " HTTP/1.0");
            out.println();
            try {
                socket.getInputStream().read();
            }
            catch (InterruptedIOException interruptedIOException) {}
            out.close();
            return context.getServlet(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        while (tokenizer.hasMoreTokens()) {
            v.addElement(tokenizer.nextToken());
        }
        String[] ret = new String[v.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)v.elementAt(i);
            ++i;
        }
        return ret;
    }

    public static URL getResource(ServletContext context, String resource) {
        if (resource == null) {
            return null;
        }
        URL url = null;
        try {
            url = context.getResource(resource);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (url == null) {
            return null;
        }
        try {
            url.openConnection().connect();
        }
        catch (IOException iOException) {
            return null;
        }
        return url;
    }
}

