/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlLog;
import com.imaginary.sql.msql.MsqlQueryData;
import com.imaginary.sql.msql.MsqlResultSet;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MsqlStatement
implements Statement {
    private ArrayList batches = new ArrayList();
    private int columnCount = -1;
    private MsqlConnection connection;
    private boolean loaded = true;
    protected MsqlLog log;
    private int maxFieldSize;
    private int maxRows;
    private ArrayList resultSets = new ArrayList();
    private int updateCount = -1;

    MsqlStatement(MsqlConnection msqlConnection) {
        this(msqlConnection, 0);
    }

    MsqlStatement(MsqlConnection msqlConnection, int n) {
        this.connection = msqlConnection;
        this.log = new MsqlLog(n, this);
    }

    public void addBatch(String string) throws SQLException {
        this.log.log("addBatch()", 2, "Adding batch: \"" + string + "\"");
        this.batches.add((Object)string);
    }

    public void cancel() throws SQLException {
        this.log.log("cancel()", 2, "Cancelling.");
        this.closeAllResults();
    }

    public void clearBatch() throws SQLException {
        this.log.log("clearBatch()", 2, "Clearing batches.");
        this.batches.clear();
    }

    public void clearWarnings() throws SQLException {
        this.log.log("clearWarnings()", 2, "Clearing warnings.");
    }

    public void close() throws SQLException {
        this.log.log("close()", 2, "Closing statement.");
        this.closeAllResults();
        this.log.close();
    }

    private synchronized void closeAllResults() {
        while (!this.loaded) {
            this.log.log("closeAllResults()", 16, "Waiting for load to complete before closing results.");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.log("closeAllResults()", 16, "Closing all result sets.");
        Iterator iterator = this.resultSets.iterator();
        while (iterator.hasNext()) {
            MsqlResultSet msqlResultSet = (MsqlResultSet)iterator.next();
            try {
                msqlResultSet.close();
            }
            catch (SQLException sQLException) {
                this.log.log("closeAllResults()", 8, "Failed to closed result set: " + sQLException.getMessage());
            }
        }
    }

    synchronized void completeLoad() {
        this.log.log("completeLoad()", 16, "Load of results completed.");
        this.connection.release();
        this.loaded = true;
        this.notifyAll();
    }

    public boolean execute(String string) throws SQLException {
        this.reset();
        this.log.log("execute()", 2, "Executing: \"" + string + "\"");
        this.connection.capture();
        AutoCloseable autoCloseable = this;
        synchronized (autoCloseable) {
            this.loaded = false;
        }
        if (!this.sendSQL(string)) {
            this.completeLoad();
            return false;
        }
        autoCloseable = new MsqlQueryData(this, this.columnCount, this.log.getLevel());
        ArrayList arrayList = this.resultSets;
        synchronized (arrayList) {
            this.resultSets.add((Object)autoCloseable);
        }
        return true;
    }

    public int[] executeBatch() throws SQLException {
        this.log.log("executeBatch()", 2, "Executing current batch.");
        int[] nArray = new int[this.batches.size()];
        int n = 0;
        while (n < this.batches.size()) {
            String string = (String)this.batches.get(n);
            try {
                nArray[n] = this.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = new SQLException(sQLException.getMessage());
                sQLException2.setNextException(sQLException);
                throw sQLException2;
            }
            ++n;
        }
        return nArray;
    }

    public synchronized ResultSet executeQuery(String string) throws SQLException {
        this.reset();
        this.log.log("executeQuery()", 2, "Executing query: \"" + string + "\"");
        this.connection.capture();
        AutoCloseable autoCloseable = this;
        synchronized (autoCloseable) {
            this.loaded = false;
        }
        if (this.sendSQL(string)) {
            autoCloseable = new MsqlQueryData(this, this.columnCount, this.log.getLevel());
            ArrayList arrayList = this.resultSets;
            synchronized (arrayList) {
                this.resultSets.add((Object)autoCloseable);
                AutoCloseable autoCloseable2 = autoCloseable;
                Object var5_5 = null;
                return autoCloseable2;
            }
        }
        this.log.log("executeQuery()", 8, "Query returned no results.");
        this.completeLoad();
        throw new MsqlException("Non-query sent to executeQuery().");
    }

    public int executeUpdate(String string) throws SQLException {
        this.reset();
        this.log.log("executeUpdate()", 2, "Executing update: \"" + string + "\"");
        this.connection.capture();
        MsqlStatement msqlStatement = this;
        synchronized (msqlStatement) {
            this.loaded = false;
        }
        if (!this.sendSQL(string)) {
            return this.updateCount;
        }
        this.log.log("executeUpdate()", 8, "Update returned result sets.");
        new MsqlQueryData(this, this.columnCount, this.log.getLevel());
        throw new MsqlException("Query sent to executeUpdate().");
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getEncoding() {
        return this.connection.getEncoding();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.resultSets.size() > 0;
    }

    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = (ResultSet)this.resultSets.get(0);
        this.resultSets.remove(0);
        return resultSet;
    }

    public int getUpdateCount() throws SQLException {
        int n = this.updateCount;
        this.updateCount = -1;
        return n;
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    private synchronized void reset() {
        this.log.log("reset()", 16, "Resetting.");
        while (!this.loaded) {
            try {
                this.resultSets.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.clearWarnings();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.resultSets.clear();
        this.updateCount = -1;
        this.columnCount = -1;
    }

    private boolean sendSQL(String string) throws SQLException {
        String string2;
        this.log.log("sendSQL()", 4, "Sending SQL to server.");
        try {
            this.connection.getOutputStream().writeString("3 " + string, this.getEncoding());
        }
        catch (IOException iOException) {
            this.log.log("sendSQL()", 8, "Failed to send SQL to server: " + iOException.getMessage());
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw new MsqlException(iOException);
        }
        try {
            string2 = this.connection.getInputStream().readString(this.getEncoding());
        }
        catch (IOException iOException) {
            this.log.log("sendSQL()", 8, "Failed to receive SQL response: " + iOException.getMessage());
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw new MsqlException(iOException);
        }
        int n = string2.indexOf(58);
        if (n == -1) {
            this.log.log("sendSQL()", 8, "Response from server did not make sense.");
            this.completeLoad();
            throw new MsqlException("Incorrect mSQL response.");
        }
        int n2 = Integer.parseInt(string2.substring(0, n));
        if (n2 == -1) {
            this.log.log("sendSQL()", 8, "Server reported an error: " + string2.substring(2));
            this.completeLoad();
            throw new MsqlException(string2.substring(2));
        }
        if ((n = string2.indexOf(58, n + 1)) == -1) {
            this.log.log("sendSQL()", 16, "Server modified " + n2 + " rows.");
            this.completeLoad();
            this.updateCount = n2;
            return false;
        }
        try {
            n2 = Integer.parseInt(string2.substring(2, n));
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("sendSQL()", 16, "I forget what this means.");
            this.completeLoad();
            this.updateCount = -1;
            this.columnCount = -1;
            return false;
        }
        this.log.log("sendSQL()", 16, "Statement required a result set with " + n2 + " columns.");
        this.columnCount = n2;
        return true;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.log.log("setQueryTimeout()", 2, "Setting query timeout to " + n + ".");
    }

    public void setCursorName(String string) throws SQLException {
        this.log.log("setCursorName()", 2, "Setting cursor name to " + string + ".");
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.log.log("setEscapeProcessing()", 2, "Setting escape processing to " + bl + ".");
        if (bl) {
            this.log.log("setEscapeProcessing()", 8, "Escape processing is not yet supported.");
            throw new SQLException("Escape processing is not yet supported.");
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.log.log("setMaxFieldSize()", 2, "Setting max field size to " + n + ".");
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.log.log("setMaxRows()", 2, "Setting max rows to " + n + ".");
        this.maxRows = n;
    }
}

