/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlColumn;
import com.imaginary.sql.msql.MsqlTypes;
import com.imaginary.sql.msql.ParsedRow;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MsqlResultSetMetaData
implements ResultSetMetaData {
    private String catalog;
    private int columnCount = -1;
    private ArrayList metaData = new ArrayList();

    MsqlResultSetMetaData(String string, ArrayList arrayList) throws SQLException {
        this.catalog = string;
        this.loadColumns(arrayList.iterator());
    }

    public String getCatalogName(int n) throws SQLException {
        return this.catalog;
    }

    private MsqlColumn getColumn(int n) throws SQLException {
        return (MsqlColumn)this.metaData.get(n - 1);
    }

    public String getColumnClassName(int n) throws SQLException {
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.columnCount;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getLength();
    }

    public String getColumnLabel(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        String string = System.getProperty("msql.oldlabels", "0");
        if (string.equals("1")) {
            return String.valueOf(msqlColumn.getTableName()) + "." + msqlColumn.getColumnName();
        }
        return msqlColumn.getColumnName();
    }

    public String getColumnName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getColumnName();
    }

    public int getColumnType(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getSQLType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        int n2 = this.getColumn(n).getMsqlType();
        return MsqlTypes.getMsqlTypeNameForMsql(n2);
    }

    public int getPrecision(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getLength();
    }

    public int getScale(int n) throws SQLException {
        switch (this.getColumnType(n)) {
            case 7: 
            case 8: {
                return 2;
            }
        }
        return 0;
    }

    public String getSchemaName(int n) throws SQLException {
        return "";
    }

    public String getTableName(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getTableName();
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getMsqlType() == 9;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public int isNullable(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        if (msqlColumn.isNullable()) {
            return 1;
        }
        return 0;
    }

    public boolean isReadOnly(int n) throws SQLException {
        return false;
    }

    public boolean isSearchable(int n) throws SQLException {
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        MsqlColumn msqlColumn = this.getColumn(n);
        return msqlColumn.getMsqlType() != 8;
    }

    public boolean isWritable(int n) throws SQLException {
        return true;
    }

    private void loadColumns(Iterator iterator) throws SQLException {
        this.columnCount = 0;
        while (iterator.hasNext()) {
            ParsedRow parsedRow = (ParsedRow)iterator.next();
            ++this.columnCount;
            this.metaData.add((Object)new MsqlColumn(this.catalog, parsedRow));
        }
    }
}

