/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlLog;
import com.imaginary.sql.msql.MsqlStatement;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public abstract class MsqlResultSet
implements ResultSet {
    protected MsqlLog log;
    private MsqlStatement statement;

    MsqlResultSet(MsqlStatement msqlStatement, int n) throws SQLException {
        this.statement = msqlStatement;
        this.log = new MsqlLog(n, this);
    }

    public void clearWarnings() throws SQLException {
        this.log.log("clearWarnings()", 2, "Clear warnings.");
    }

    public void close() throws SQLException {
        this.log.log("close()", 2, "Closing result set.");
        this.log.close();
    }

    public void complete() {
        this.log.log("complete()", 16, "Result set complete.");
        if (this.statement != null) {
            this.statement.completeLoad();
        }
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"));
        }
        return new BigDecimal(new BigInteger(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return new BigDecimal(new BigInteger("0"), n2);
        }
        return new BigDecimal(new BigInteger(string), n2);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return new CharArrayReader(this.getString(n).toCharArray());
    }

    public String getCursorName() throws SQLException {
        this.log.log("getCursorName()", 8, "Cursors not supported.");
        throw new SQLException("mSQL does not support cursors.");
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getDate()", 8, "Invalid date format: " + string);
                throw new SQLException("Invalid date format.");
            }
        }
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getDate()", 8, "Invalid date format: " + string);
                throw new MsqlException("Invalid date format.");
            }
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getDouble()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public String getEncoding() {
        if (this.statement != null) {
            return this.statement.getEncoding();
        }
        return "8859_1";
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getFloat()", 8, "Invalid number format: " + string);
            throw new MsqlException(numberFormatException);
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getInt()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getLong()", 8, "Invalid numver format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Character((char)this.getInt(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, 0);
            }
            case 3: {
                return this.getBigDecimal(n, 0);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        this.log.log("getObject()", 8, "Unknown SQL type " + n2 + ".");
        throw new MsqlException("Unknown SQL type: " + n2);
    }

    public abstract int getRow() throws SQLException;

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.log.log("getShort()", 8, "Invalid number format: " + string + ".");
            throw new MsqlException(numberFormatException);
        }
    }

    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getTime()", 8, "Invalid time format: " + string + ".");
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
            simpleDateFormat.setCalendar(calendar);
            java.util.Date date = simpleDateFormat.parse(string);
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            try {
                return new Time(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log("getTime()", 8, "Invalid time format: " + string + ".");
                throw new SQLException("Invalid time format.");
            }
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new Timestamp(Long.parseLong(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public boolean isAfterLast() throws SQLException {
        return this.getRow() == -2;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() == 0;
    }

    public abstract boolean next() throws SQLException;

    public abstract boolean wasNull() throws SQLException;

    public abstract String getString(int var1) throws SQLException;

    public abstract boolean getBoolean(int var1) throws SQLException;

    public abstract byte getByte(int var1) throws SQLException;

    public abstract byte[] getBytes(int var1) throws SQLException;

    public abstract InputStream getAsciiStream(int var1) throws SQLException;

    public abstract InputStream getUnicodeStream(int var1) throws SQLException;

    public abstract InputStream getBinaryStream(int var1) throws SQLException;

    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public abstract int findColumn(String var1) throws SQLException;
}

