/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlAsciiInputStream;
import com.imaginary.sql.msql.MsqlConnection;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlResultSet;
import com.imaginary.sql.msql.MsqlResultSetMetaData;
import com.imaginary.sql.msql.MsqlRow;
import com.imaginary.sql.msql.MsqlStatement;
import com.imaginary.sql.msql.MsqlUnicodeInputStream;
import com.imaginary.sql.msql.RowTokenizer;
import com.imaginary.util.Encoder;
import com.imaginary.util.NoSuchEncoderException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class MsqlQueryData
extends MsqlResultSet {
    private int columnCount;
    private HashMap columnMap;
    private boolean complete = false;
    private MsqlConnection connection;
    private MsqlRow currentRow;
    protected String lastColumn;
    private ResultSetMetaData metaData;
    private SQLException readException;
    private int rowNumber = -1;
    private ArrayList rows = new ArrayList();

    MsqlQueryData(MsqlStatement msqlStatement, int n, int n2) throws SQLException {
        this(null, msqlStatement, n, n2, false);
    }

    MsqlQueryData(MsqlConnection msqlConnection, int n, int n2) throws SQLException {
        this(msqlConnection, null, n, n2, false);
    }

    MsqlQueryData(MsqlConnection msqlConnection, int n, int n2, boolean bl) throws SQLException {
        this(msqlConnection, null, n, n2, bl);
    }

    MsqlQueryData(MsqlConnection msqlConnection, MsqlStatement msqlStatement, int n, int n2, boolean bl) throws SQLException {
        super(msqlStatement, n2);
        this.connection = msqlConnection;
        this.columnCount = n;
        if (!bl) {
            1 var6_6 = new 1();
            var6_6.setPriority(4);
            var6_6.start();
        }
    }

    protected void addRow(MsqlRow msqlRow) {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.rows.add((Object)msqlRow);
            this.rows.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        super.close();
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    return;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void complete() {
        super.complete();
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            this.complete = true;
            this.rows.notifyAll();
            return;
        }
    }

    public int findColumn(String string) throws SQLException {
        String string2;
        int n;
        ResultSetMetaData resultSetMetaData;
        this.log.log("findColumn()", 2, "Finding column " + string);
        if (this.columnMap == null) {
            resultSetMetaData = this.getMetaData();
            this.columnMap = new HashMap();
            n = 1;
            while (n <= this.columnCount) {
                string2 = String.valueOf(resultSetMetaData.getTableName(n)) + "." + resultSetMetaData.getColumnName(n);
                this.columnMap.put((Object)string2, (Object)new Integer(n));
                ++n;
            }
        }
        if (!this.columnMap.containsKey((Object)string)) {
            resultSetMetaData = this.columnMap.keySet().iterator();
            while (resultSetMetaData.hasNext()) {
                string2 = (String)resultSetMetaData.next();
                n = string2.indexOf(".");
                String string3 = n == -1 ? string2 : (n >= string2.length() - 1 ? string2.substring(0, n) : string2.substring(n + 1));
                if (!string3.equals(string)) continue;
                return (Integer)this.columnMap.get((Object)string2);
            }
            this.log.log("findcolumn()", 8, "Invalid column name.");
            throw new MsqlException("Invalid column name: " + string);
        }
        return (Integer)this.columnMap.get((Object)string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.getColumn(n);
        try {
            return new MsqlAsciiInputStream(this.lastColumn);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        try {
            Encoder encoder = Encoder.getInstance(1);
            this.getColumn(n);
            return new ByteArrayInputStream(encoder.decode(this.lastColumn));
        }
        catch (NoSuchEncoderException noSuchEncoderException) {
            throw new MsqlException(noSuchEncoderException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return false;
        }
        if (this.lastColumn.length() == 0) {
            return false;
        }
        char c = this.lastColumn.charAt(0);
        return c != '0' && c != '\u0000' && c != 'n' && c != 'N';
    }

    public byte getByte(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull() || this.lastColumn.length() == 0) {
            return 0;
        }
        try {
            return this.lastColumn.getBytes("8859_1")[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        String string = this.getString(n);
        try {
            Encoder encoder = Encoder.getInstance(1);
            return encoder.decode(string);
        }
        catch (NoSuchEncoderException noSuchEncoderException) {
            throw new MsqlException(noSuchEncoderException);
        }
    }

    protected void getColumn(int n) throws SQLException {
        this.log.log("getColumn()", 16, "Getting column " + n);
        try {
            this.lastColumn = this.currentRow.getColumn(n - 1, 0);
            return;
        }
        catch (Exception exception) {
            if (this.currentRow == null) {
                throw new MsqlException("Result set cursor is positioned outside of the result set.");
            }
            throw new MsqlException(exception);
        }
    }

    MsqlConnection getConnection() throws SQLException {
        if (this.connection == null) {
            return (MsqlConnection)((MsqlStatement)this.getStatement()).getConnection();
        }
        return this.connection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        this.log.log("getMetaData()", 2, "Getting meta data.");
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.metaData != null) {
                return this.metaData;
            }
            while (true) {
                if (this.metaData != null) {
                    return this.metaData;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getRow() throws SQLException {
        return this.rowNumber + 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MsqlRow getRowData(int n) throws SQLException {
        this.clearWarnings();
        if (n < 0) {
            throw new MsqlException("Attempt to access a non-existent row.");
        }
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            if (this.readException != null) {
                throw this.readException;
            }
            while (true) {
                if (this.rows.size() > n) {
                    return (MsqlRow)this.rows.get(n);
                }
                if (this.complete) {
                    throw new MsqlException("Attempt to access a non-existent row.");
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public String getString(int n) throws SQLException {
        this.getColumn(n);
        if (this.wasNull()) {
            return null;
        }
        return this.lastColumn;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.getColumn(n);
        try {
            return new MsqlUnicodeInputStream(this.lastColumn);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MsqlException(unsupportedEncodingException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLast() throws SQLException {
        ArrayList arrayList = this.rows;
        synchronized (arrayList) {
            while (true) {
                if (this.complete) {
                    return this.rowNumber == this.rows.size() - 1;
                }
                try {
                    this.rows.wait(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected ResultSetMetaData loadMetaData() throws SQLException {
        MsqlConnection msqlConnection = this.getConnection();
        ArrayList arrayList = new ArrayList();
        String string = msqlConnection.getCatalog();
        while (true) {
            Object object;
            byte[] byArray;
            try {
                byArray = msqlConnection.getInputStream().read();
            }
            catch (IOException iOException) {
                this.log.log("loadMetaData()", 8, "Error reading meta data from stream: " + iOException.getMessage());
                throw new MsqlException(iOException);
            }
            if (byArray.length > 2 && byArray[0] == 45 && byArray[1] == 49 && byArray[2] == 58) {
                try {
                    object = new String(byArray, this.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.log.log("loadMetaData()", 8, "Error with encoding on read: " + unsupportedEncodingException.getMessage());
                    throw new MsqlException(unsupportedEncodingException);
                }
                this.log.log("loadMetaData()", 8, (String)object);
                throw new MsqlException((String)object);
            }
            if (byArray.length > 4 && byArray[0] == 45 && byArray[1] == 49 && byArray[2] == 48 && byArray[3] == 48 && byArray[4] == 58) {
                return new MsqlResultSetMetaData(string, arrayList);
            }
            object = new RowTokenizer(byArray, this.getEncoding(), this.log.getLevel());
            arrayList.add(object);
        }
    }

    protected void loadResults() throws SQLException {
        this.log.log("loadResults()", 16, "Loading results.");
        MsqlConnection msqlConnection = this.getConnection();
        while (true) {
            byte[] byArray;
            Object object;
            try {
                object = msqlConnection.getInputStream();
                byArray = ((MsqlInputStream)object).read();
            }
            catch (Exception exception) {
                throw new MsqlException(exception);
            }
            if (byArray.length > 2 && byArray[0] == 45 && byArray[1] == 49 && byArray[2] == 58) {
                try {
                    object = new String(byArray, this.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new MsqlException(unsupportedEncodingException);
                }
                throw new MsqlException((String)object);
            }
            if (byArray.length > 4 && byArray[0] == 45 && byArray[1] == 49 && byArray[2] == 48 && byArray[3] == 48 && byArray[4] == 58) break;
            try {
                object = this.readRow(byArray);
                if (object == null) continue;
                this.addRow((MsqlRow)object);
            }
            catch (Exception exception) {
                throw new MsqlException(exception);
            }
        }
        try {
            this.metaData = this.loadMetaData();
            this.complete();
            return;
        }
        catch (SQLException sQLException) {
            this.metaData = null;
            throw sQLException;
        }
    }

    public boolean next() throws SQLException {
        if (this.readException != null) {
            throw this.readException;
        }
        this.log.log("next()", 2, "Moving from row " + this.rowNumber + " to row " + (this.rowNumber + 1) + ".");
        ++this.rowNumber;
        try {
            this.currentRow = this.getRowData(this.rowNumber);
        }
        catch (SQLException sQLException) {
            this.rowNumber = -2;
            return false;
        }
        return true;
    }

    protected MsqlRow readRow(byte[] byArray) throws SQLException {
        RowTokenizer rowTokenizer = new RowTokenizer(byArray, this.getEncoding(), this.log.getLevel());
        return new MsqlRow(rowTokenizer, this.getEncoding());
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumn == null;
    }

    static /* synthetic */ SQLException access$0(MsqlQueryData msqlQueryData) {
        return msqlQueryData.readException;
    }

    private final class 1
    extends Thread {
        public void run() {
            try {
                MsqlQueryData.this.loadResults();
                return;
            }
            catch (SQLException sQLException) {
                MsqlQueryData.this.log.log("MsqlQueryData()", 8, "Results load failed: " + sQLException.getMessage());
                MsqlQueryData.this.readException = sQLException;
                MsqlQueryData.this.complete();
                return;
            }
        }

        /* synthetic */ 1() {
        }
    }
}

