/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import java.io.PrintStream;
import java.sql.DriverManager;

public class MsqlLog {
    public static final int NONE = 0;
    public static final int FATAL = 1;
    public static final int JDBC = 2;
    public static final int MSQL = 4;
    public static final int ERROR = 8;
    public static final int DRIVER = 16;
    public static final int METHODS = 32;
    public static final int THREADS = 64;
    public static final int ALL = 127;
    private int level = 0;
    private Object owner;

    public MsqlLog(int n, Object object) {
        this.level = n;
        this.owner = object;
    }

    public void close() {
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream != null) {
            printStream.flush();
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void log(String string, int n, String string2) {
        String string3;
        if ((this.level & n) == 0) {
            return;
        }
        switch (n) {
            case 0: {
                return;
            }
            case 1: {
                string3 = "FATAL ERROR";
                break;
            }
            case 2: {
                string3 = "JDBC";
                break;
            }
            case 4: {
                string3 = "mSQL";
                break;
            }
            case 8: {
                string3 = "ERROR";
                break;
            }
            case 16: {
                string3 = "DRIVER";
                break;
            }
            default: {
                string3 = "UNK";
            }
        }
        if ((this.level & 0x20) != 0) {
            string3 = String.valueOf(string3) + " " + this.owner.getClass().getName() + "." + string;
        }
        if ((this.level & 0x40) != 0) {
            string3 = String.valueOf(string3) + " (" + Thread.currentThread().getName() + ")";
        }
        string3 = String.valueOf(string3) + ": " + string2;
        PrintStream printStream = DriverManager.getLogStream();
        if (printStream == null) {
            if (n == 8 || n == 1) {
                System.err.println(string3);
                return;
            }
            System.out.println(string3);
            return;
        }
        printStream.println(string3);
    }
}

