/*
 * Decompiled with CFR 0.152.
 */
package com.imaginary.sql.msql;

import com.imaginary.sql.msql.MsqlDatabaseMetaData;
import com.imaginary.sql.msql.MsqlException;
import com.imaginary.sql.msql.MsqlInputStream;
import com.imaginary.sql.msql.MsqlLog;
import com.imaginary.sql.msql.MsqlOutputStream;
import com.imaginary.sql.msql.MsqlPreparedStatement;
import com.imaginary.sql.msql.MsqlStatement;
import com.sun.java.util.collections.ArrayList;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class MsqlConnection
implements Connection {
    private Socket connection;
    protected String database;
    private String encoding = "8859_1";
    private boolean inUse = false;
    protected MsqlInputStream input;
    private MsqlLog log;
    protected MsqlOutputStream output;
    private ArrayList statements = new ArrayList();
    protected String url;
    protected String user;
    protected int version;
    protected String versionString;

    MsqlConnection(String string, String string2, int n, String string3, Properties properties) throws SQLException {
        Object object;
        String string4 = ((Hashtable)properties).containsKey("logging") ? (String)((Hashtable)properties).get("logging") : System.getProperty("imaginary.msql-jdbc.logging", "NONE");
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).equals("NONE")) continue;
            if (((String)object).equals("ALL")) {
                n2 = 127;
                break;
            }
            if (((String)object).equals("FATAL")) {
                n2 |= 1;
                continue;
            }
            if (((String)object).equals("JDBC")) {
                n2 |= 2;
                continue;
            }
            if (((String)object).equals("MSQL")) {
                n2 |= 4;
                continue;
            }
            if (((String)object).equals("ERROR")) {
                n2 |= 8;
                continue;
            }
            if (!((String)object).equals("DRIVER")) continue;
            n2 |= 0x10;
        }
        this.log = new MsqlLog(n2, this);
        this.log.log("MsqlConnection()", 16, "Assigned logging level of " + string4);
        this.url = string;
        this.user = properties.getProperty("user", "nobody");
        this.connect(string2, n, this.user);
        this.setCatalog(string3);
        this.encoding = properties.getProperty("encoding");
        if (this.encoding == null || this.encoding.equals("")) {
            this.encoding = System.getProperty("imaginary.msql-jdbc.encoding", "8859_1");
        }
        this.log.log("MsqlConnection()", 16, "Set encoding to " + this.encoding);
        try {
            object = new byte[1];
            object[0] = 112;
            String string5 = new String((byte[])object, this.encoding);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.log.log("MsqlConnection()", 8, "Unsupported encoding, using 8859_1");
            this.encoding = "8859_1";
            return;
        }
    }

    synchronized void capture() {
        this.log.log("capture()", 16, "Capture attempted by " + Thread.currentThread().getName() + ".");
        while (this.isInUse()) {
            try {
                this.wait(1500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.log("capture()", 16, "Capture succeeded by " + Thread.currentThread().getName() + ".");
        this.inUse = true;
    }

    private synchronized void clean() {
        this.log.log("clean()", 16, "Cleaning up connection resources.");
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
            this.input = null;
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {}
            this.output = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {}
            this.connection = null;
        }
        this.user = null;
        this.release();
    }

    public void clearWarnings() throws SQLException {
        this.log.log("clearWarnings()", 2, "Warnings cleared.");
    }

    public synchronized void close() throws SQLException {
        IOException iOException = null;
        this.log.log("close()", 2, "Closing connection.");
        if (this.isClosed()) {
            this.log.log("close()", 8, "Cannot close a closed connection.");
            throw new MsqlException("This connection is already closed.");
        }
        this.capture();
        this.log.log("close()", 4, "Sending close to server.");
        try {
            this.output.writeString("1", this.encoding);
            this.output.flush();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
            this.log.log("close()", 8, "Failed to send close to server.");
        }
        this.clean();
        this.log.close();
        if (iOException != null) {
            throw new MsqlException(iOException);
        }
    }

    public void commit() throws SQLException {
        this.log.log("commit()", 2, "Commit received.");
    }

    private synchronized void connect(String string, int n, String string2) throws SQLException {
        String string3;
        this.log.log("connect()", 2, "Connect to " + string + ":" + n + " under UID " + string2);
        this.capture();
        this.log.log("connect()", 16, "Created socket.");
        try {
            this.connection = new Socket(string, n);
            this.input = new MsqlInputStream(this.connection.getInputStream());
            this.output = new MsqlOutputStream(this.connection.getOutputStream());
        }
        catch (IOException iOException) {
            this.log.log("connect()", 1, "Socket and stream creation failed: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        try {
            string3 = this.input.readString(this.encoding);
        }
        catch (IOException iOException) {
            this.log.log("connect()", 1, "Failed to read version response from the server: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        if (string3.startsWith("0:22:") || string3.startsWith("0:23:")) {
            this.log.log("connect()", 4, "Responded with version \"" + string3 + "\"");
            this.version = 2;
            this.versionString = string3.substring(5);
        } else if (string3.startsWith("0:6:")) {
            this.log.log("connect()", 4, "Responded with version \"" + string3 + "\"");
            this.version = 1;
            this.versionString = string3.substring(4);
        } else {
            this.log.log("connect()", 4, "Responded with version \"" + string3 + "\"");
            this.log.log("connect()", 1, "Unsupported verion string.");
            this.clean();
            throw new MsqlException("Unsupported mSQL version.");
        }
        this.log.log("connect()", 4, "Sending user name");
        try {
            this.output.writeString(string2, this.encoding);
        }
        catch (IOException iOException) {
            this.log.log("connect()", 1, "Failed to send user name: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        try {
            string3 = this.input.readString(this.encoding);
        }
        catch (IOException iOException) {
            this.log.log("connect()", 1, "Failed to read user name validation from server: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        if (!string3.startsWith("-100:")) {
            this.log.log("connect()", 4, "Responded with \"" + string3 + "\"");
            this.log.log("connect()", 1, "Access denied.");
            this.clean();
            throw new MsqlException("Access to server denied.");
        }
        this.release();
    }

    public synchronized Statement createStatement() throws SQLException {
        this.log.log("createStatement()", 2, "Creating statement.");
        MsqlStatement msqlStatement = new MsqlStatement(this, this.log.getLevel());
        this.statements.add((Object)msqlStatement);
        return msqlStatement;
    }

    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    public String getCatalog() throws SQLException {
        return this.database;
    }

    public String getEncoding() {
        return this.encoding;
    }

    MsqlInputStream getInputStream() {
        return this.input;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new MsqlDatabaseMetaData(this, this.log.getLevel());
    }

    MsqlOutputStream getOutputStream() {
        return this.output;
    }

    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    public synchronized String getUser() throws SQLException {
        return this.user;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public synchronized boolean isClosed() {
        return this.connection == null;
    }

    synchronized boolean isInUse() {
        return this.inUse;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.log.log("prepareCall()", 2, "Preparing call \"" + string + "\".");
        this.log.log("prepareCall()", 8, "Prepared statements not supported.");
        throw new SQLException("mSQL does not support stored procedures.");
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.log.log("prepareStatement()", 2, "Preparing statement (sql=\"" + string + "\").");
        MsqlPreparedStatement msqlPreparedStatement = new MsqlPreparedStatement(this, string, this.log.getLevel());
        this.statements.add((Object)msqlPreparedStatement);
        return msqlPreparedStatement;
    }

    synchronized void release() {
        this.log.log("release()", 16, "Connection released by " + Thread.currentThread().getName() + ".");
        this.inUse = false;
        this.notifyAll();
    }

    public void rollback() throws SQLException {
        this.log.log("rollback()", 2, "Rollback received.");
        this.log.log("rollback()", 8, "Rollback not supported.");
        throw new MsqlException("mSQL does not support rollbacks.");
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.log.log("setAutoCommit()", 2, "Setting auto-commit to " + bl + ".");
        if (!bl) {
            this.log.log("setAutoCommit()", 8, "Auto-commit = false not supported.");
            throw new MsqlException("mSQL must always be auto-commit = true.");
        }
    }

    public synchronized void setCatalog(String string) throws SQLException {
        String string2;
        this.capture();
        this.log.log("setCatalog()", 4, "Sending select database for " + string + ".");
        try {
            this.output.writeString("2 " + string, this.encoding);
        }
        catch (IOException iOException) {
            this.log.log("setCatalog()", 1, "Failed to send database select: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        try {
            string2 = this.input.readString(this.encoding);
        }
        catch (IOException iOException) {
            this.log.log("setCatalog()", 1, "Failed to receive database select response: " + iOException.getMessage());
            this.clean();
            throw new MsqlException(iOException);
        }
        if (string2.startsWith("-1:")) {
            this.log.log("setCatalog()", 1, "Received error from server: " + string2);
            this.clean();
            throw new MsqlException(string2);
        }
        this.database = string;
        this.release();
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.log.log("setReadOnly()", 2, "Setting read-only to " + bl + ".");
        if (bl) {
            this.log.log("setReadOnly()", 8, "Read-only connections not supported.");
            throw new MsqlException("mSQL does not support read-only mode.");
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.log.log("setTransactionIsolation()", 2, "Setting transaction isolation to " + n + ".");
    }
}

