﻿/*
*
* @name JSLib - Biblioteca JavaScript - Editor básico de Layout
* @license http://www.gnu.org/licenses/lgpl.html LGPL License
* @author Everton Pacheco
* @author Luciano Lima <beavess@gmail.com>
* @author Ramon Sacramento
* @author Ricardo Miranda
* @created Maio/2008
* @download http://beaves.hostsnake.com/jslib/jslib.zip
*
*/

// Função que cria a div do gerenciador de layout
function carregar_jslib() {
	//Criação da Div principal da interface
	var obj_jslib = document.createElement('div');
	var jslib_css = ('width:380px; height:auto; border:1px solid #333; background-color:#CCC; z-index:100; position:absolute; top:0px; right:0px; font-size:14px; -moz-opacity:0.8; opacity:.80; filter:alpha(opacity=80); text-align:center; display:none; visibility:hidden');
	atribuir_css(obj_jslib,jslib_css);
	obj_jslib.setAttribute('id','jslib');
	//Divs internas
	var jslib_option = document.createElement('div');
	var jslib_opt_param = document.createElement('div');
	var option_css = ('width:112px; height:100%; border-right:1px solid #333; background-color:#CDCDCD; float:left;');
	var opt_param_css = ('width:265px; height:100%; border-left:1px solid #333; background-color:#CDCDCD; float:left;');
	atribuir_css(jslib_option,option_css);
	jslib_option.setAttribute('id','jslib_option');
	atribuir_css(jslib_opt_param,opt_param_css);
	jslib_opt_param.setAttribute('id','jslib_opt_param');
	obj_jslib.appendChild(jslib_option);
	obj_jslib.appendChild(jslib_opt_param);
	//Criação do elemento select para escolha das tags
	var select_tag = document.createElement('select');
	adicionar_evento(select_tag,'onchange',0);
	select_tag.setAttribute('size','1');
	select_tag.setAttribute('id','jslib_tagselect');
	//Options do select
	var select_opt_tag = document.createElement('option');
	var select_opt_body = document.createElement('option');
	var select_opt_div = document.createElement('option');
	var select_opt_p = document.createElement('option');
	select_opt_tag.setAttribute('disabled','disabled');
	select_opt_tag.setAttribute('selected','selected');
	select_opt_tag.appendChild(document.createTextNode('Escolha a tag'));
	select_opt_body.setAttribute('value','BODY');
	select_opt_body.appendChild(document.createTextNode('Body'));
	select_opt_div.setAttribute('value','DIV');
	select_opt_div.appendChild(document.createTextNode('Div'));
	select_opt_p.setAttribute('value','P');
	select_opt_p.appendChild(document.createTextNode('P'));
    select_tag.appendChild(select_opt_tag);
	select_tag.appendChild(select_opt_body);
	select_tag.appendChild(select_opt_div);
	select_tag.appendChild(select_opt_p);
	document.body.appendChild(obj_jslib);
	document.getElementById('jslib_option').appendChild(select_tag);
	//Botão fechar
	var close_button = document.createElement('a');
	close_button.setAttribute('href','javascript:void(0)');
    var close_css = 'text-decoration:underline;text-align:center;font-family:Tahoma;font-size:12px;width:100px;border:1px solid #000000;float:left;padding:2px 4px 4px 4px;margin-left:1px;color:#000000';
	atribuir_css(close_button,close_css);
	var txtFechar = document.createTextNode('Fechar janela');	
	close_button.appendChild(txtFechar);
	adicionar_evento(close_button,'onclick',5);
	jslib_option.appendChild(close_button);	
}

/* Função que verifica se a div jslib foi criada. Se sim, é alterado o valor do display e do visibility no css fazendo com que
apareça e suma; se não ela é criada chamando a função carregar_jslib()*/
function mostra_jslib() {
	var jslib = document.getElementById('jslib');
	if (jslib) {
		if (jslib.style.display == 'none') {
			jslib.style.display = 'block';
			jslib.style.visibility = 'visible';
		} else {
			jslib.style.display = 'none';
			jslib.style.visibility = 'hidden';
		}
	} else {
		carregar_jslib();
	}
}

// Função que carrega as opções de alteração da tag selecionada na combo-box
function carregar_parametros(value) {
	var tag = value;
	var option_param = new Array();
	limpar_parametros();
	switch (tag) {
		case 'BODY':
	        /*Tabela da paleta de cores do background da tag body*/	
			var table = document.createElement('table');
			var table_css = 'width:130px;border:1px solid #333;height:120px;font-family:Verdana;font-size:12px;text-align:center;float:left;margin:5px 0px 0px 5px;color:#000000;"';
			atribuir_css(table,table_css);
			table.setAttribute('id','BODY');
			table.setAttribute('cellpadding','0');
			table.setAttribute('cellspacing','0');
			table.setAttribute('border','1');
			var tbody = document.createElement('tbody');
			var first_tr = document.createElement('tr');
			var first_td = document.createElement('td');
			var tbl_name = document.createTextNode('Background Color');
			first_td.appendChild(tbl_name);
			first_td.setAttribute('colSpan','4');
			first_td.style.backgroundColor = '#FFFFFF';
			first_tr.appendChild(first_td);
			tbody.appendChild(first_tr);
			for (var a=0;a<4;a++) {
				var newtr = document.createElement('tr');
				newtr.setAttribute('id','backgroundColor');
				for (var b=0;b<4;b++) {
					var newtd = document.createElement('td');
					var tdText = document.createTextNode('\u00a0');
					newtd.style.width = '25%';
					newtd.style.height = '20%';
					adicionar_evento(newtd,'onclick',1);
					newtd.appendChild(tdText);
					newtr.appendChild(newtd);
				}
				tbody.appendChild(newtr);
			}
			tbody.childNodes[1].childNodes[0].id = tbody.childNodes[1].childNodes[0].style.backgroundColor = '#000000';
			tbody.childNodes[1].childNodes[1].id = tbody.childNodes[1].childNodes[1].style.backgroundColor = '#CC0000'; 
			tbody.childNodes[1].childNodes[2].id = tbody.childNodes[1].childNodes[2].style.backgroundColor = '#00CC00';
			tbody.childNodes[1].childNodes[3].id = tbody.childNodes[1].childNodes[3].style.backgroundColor = '#0000CC';
			tbody.childNodes[2].childNodes[0].id = tbody.childNodes[2].childNodes[0].style.backgroundColor = '#999999';
			tbody.childNodes[2].childNodes[1].id = tbody.childNodes[2].childNodes[1].style.backgroundColor = '#FF0000';
			tbody.childNodes[2].childNodes[2].id = tbody.childNodes[2].childNodes[2].style.backgroundColor = '#00FF00';
			tbody.childNodes[2].childNodes[3].id = tbody.childNodes[2].childNodes[3].style.backgroundColor = '#0000FF';
			tbody.childNodes[3].childNodes[0].id = tbody.childNodes[3].childNodes[0].style.backgroundColor = '#CCCCCC';
			tbody.childNodes[3].childNodes[1].id = tbody.childNodes[3].childNodes[1].style.backgroundColor = '#FF9999';
			tbody.childNodes[3].childNodes[2].id = tbody.childNodes[3].childNodes[2].style.backgroundColor = '#99FF99';
			tbody.childNodes[3].childNodes[3].id = tbody.childNodes[3].childNodes[3].style.backgroundColor = '#9999FF';
			tbody.childNodes[4].childNodes[0].id = tbody.childNodes[4].childNodes[0].style.backgroundColor = '#FFFFFF';
			tbody.childNodes[4].childNodes[1].id = tbody.childNodes[4].childNodes[1].style.backgroundColor = '#FFCCCC';
			tbody.childNodes[4].childNodes[2].id = tbody.childNodes[4].childNodes[2].style.backgroundColor = '#CCFFCC';
			tbody.childNodes[4].childNodes[3].id = tbody.childNodes[4].childNodes[3].style.backgroundColor = '#CCCCFF';
			table.appendChild(tbody);
			option_param[0] = table;
			/*Fim da tabela da paleta de cores do background da tag body*/

			/*Tabela da paleta de cores da fonte da tag body*/
			table = document.createElement('table');
			table_css = 'width:120px;border:1px solid #333;height:120px;font-family:Verdana;font-size:12px;text-align:center;float:left;margin:5px 0px 0px 5px;color:#000000;';
			atribuir_css(table,table_css);
			table.setAttribute('id','BODY');
			table.setAttribute('cellpadding','0');
			table.setAttribute('cellspacing','0');
			table.setAttribute('border','1');
			tbody = document.createElement('tbody');
			first_tr = document.createElement('tr');
			first_td = document.createElement('td');
			tbl_name = document.createTextNode('Font Color');
			first_td.appendChild(tbl_name);
			first_td.setAttribute('colSpan','4');
			first_td.style.backgroundColor = '#FFFFFF';
			first_tr.appendChild(first_td);
			tbody.appendChild(first_tr);
			for (var a=0;a<4;a++) {
				var newtr = document.createElement('tr');
				newtr.setAttribute('id','color');
				for (var b=0;b<4;b++) {
					var newtd = document.createElement('td');
					var tdText = document.createTextNode('\u00a0');
					newtd.style.width = '25%';
					newtd.style.height = '20%';
					adicionar_evento(newtd,'onclick',1);
					newtd.appendChild(tdText);
					newtr.appendChild(newtd);
				}
				tbody.appendChild(newtr);
			}
			tbody.childNodes[1].childNodes[0].id = tbody.childNodes[1].childNodes[0].style.backgroundColor = '#000000';
			tbody.childNodes[1].childNodes[1].id = tbody.childNodes[1].childNodes[1].style.backgroundColor = '#CC0000'; 
			tbody.childNodes[1].childNodes[2].id = tbody.childNodes[1].childNodes[2].style.backgroundColor = '#00CC00';
			tbody.childNodes[1].childNodes[3].id = tbody.childNodes[1].childNodes[3].style.backgroundColor = '#0000CC';
			tbody.childNodes[2].childNodes[0].id = tbody.childNodes[2].childNodes[0].style.backgroundColor = '#999999';
			tbody.childNodes[2].childNodes[1].id = tbody.childNodes[2].childNodes[1].style.backgroundColor = '#FF0000';
			tbody.childNodes[2].childNodes[2].id = tbody.childNodes[2].childNodes[2].style.backgroundColor = '#00FF00';
			tbody.childNodes[2].childNodes[3].id = tbody.childNodes[2].childNodes[3].style.backgroundColor = '#0000FF';
			tbody.childNodes[3].childNodes[0].id = tbody.childNodes[3].childNodes[0].style.backgroundColor = '#CCCCCC';
			tbody.childNodes[3].childNodes[1].id = tbody.childNodes[3].childNodes[1].style.backgroundColor = '#FF9999';
			tbody.childNodes[3].childNodes[2].id = tbody.childNodes[3].childNodes[2].style.backgroundColor = '#99FF99';
			tbody.childNodes[3].childNodes[3].id = tbody.childNodes[3].childNodes[3].style.backgroundColor = '#9999FF';
			tbody.childNodes[4].childNodes[0].id = tbody.childNodes[4].childNodes[0].style.backgroundColor = '#FFFFFF';
			tbody.childNodes[4].childNodes[1].id = tbody.childNodes[4].childNodes[1].style.backgroundColor = '#FFCCCC';
			tbody.childNodes[4].childNodes[2].id = tbody.childNodes[4].childNodes[2].style.backgroundColor = '#CCFFCC';
			tbody.childNodes[4].childNodes[3].id = tbody.childNodes[4].childNodes[3].style.backgroundColor = '#CCCCFF';
			table.appendChild(tbody);
			option_param[1] = table;
			/*Fim da tabela da paleta de cores da fonte da tag body*/

			/*Combo para escolha da família de fonte da tag body*/
   			var obj_select =  document.createElement('select');
			obj_select.setAttribute('id','fontFamily');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			var txtEscolha = document.createTextNode('Escolha a fonte');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','Arial');
			var txtOption1 = document.createTextNode('Arial');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','Tahoma');
			var txtOption2 = document.createTextNode('Tahoma');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','Trebuchet MS');
			var txtOption3 = document.createTextNode('Trebuchet MS');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','Verdana');
			var txtOption4 = document.createTextNode('Verdana');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			var select_css = 'font-family:Verdana;font-size:12px;float:left;width:130px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[2] = obj_select;
			/*Fim do combo para escolha da familia de fonte da tag body*/

			/*Combo do alinhamento da fonte da tag body*/
   			obj_select =  document.createElement('select');
			obj_select.setAttribute('id','textAlign');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			txtEscolha = document.createTextNode('Alinhamento');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','left');
			txtOption1 = document.createTextNode('Esquerda');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','center');
			txtOption2 = document.createTextNode('Centralizado');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','right');
			txtOption3 = document.createTextNode('Direita');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','justify');
			txtOption4 = document.createTextNode('Justificado');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			select_css = 'font-family:Verdana;font-size:12px;float:left;width:120px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[3] = obj_select;
			/*Fim do combo do alinhamento da fonte da tag body*/

			/*Links do tamanho da fonte da tag body*/
			var span = document.createElement('span');
			var span_css = 'font-family:Verdana;font-size:12px;color:#000000;float:left;width:250px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(span,span_css);
			var span_text = document.createTextNode('Tamanho da fonte: ');
			span.appendChild(span_text);
			var span_link_aumenta = document.createElement('a');
			var span_link_diminui = document.createElement('a');
			var link_aumenta_text = document.createTextNode('A+');
			var espaco = document.createTextNode(' | ');
			var link_diminui_text = document.createTextNode('A-');
			span_link_aumenta.setAttribute('href','javascript:void(0)');
			span_link_aumenta.setAttribute('id','+1');
			span_link_diminui.setAttribute('href','javascript:void(0)');
			span_link_diminui.setAttribute('id','-1');
			adicionar_evento(span_link_aumenta,'onclick',3);	
			adicionar_evento(span_link_diminui,'onclick',3);	
	        span_link_aumenta.appendChild(link_aumenta_text);
	        span_link_diminui.appendChild(link_diminui_text);
			span.appendChild(span_link_aumenta);
			span.appendChild(espaco);
			span.appendChild(span_link_diminui);
			option_param[4] = span;
			/*Fim dos links do tamanho da fonte da tag body*/
			break;
		case 'DIV':
		   /*Tabela da paleta de cores do background da tag div*/
			var table = document.createElement('table');
			var table_css = 'width:130px;border:1px solid #333;height:120px;font-family:Verdana;font-size:12px;text-align:center;float:left;margin:5px 0px 0px 5px;color:#000000;';
			atribuir_css(table,table_css);
			table.setAttribute('id','DIV');
			table.setAttribute('cellpadding','0');
			table.setAttribute('cellspacing','0');
			table.setAttribute('border','1');
			var tbody = document.createElement('tbody');
			var first_tr = document.createElement('tr');
			var first_td = document.createElement('td');
			var tbl_name = document.createTextNode('Background Color');
			first_td.appendChild(tbl_name);
			first_td.setAttribute('colSpan','4');
			first_td.style.backgroundColor = '#FFFFFF';
			first_tr.appendChild(first_td);
			tbody.appendChild(first_tr);
			for (var a=0;a<4;a++) {
				var newtr = document.createElement('tr');
				newtr.setAttribute('id','backgroundColor');
				for (var b=0;b<4;b++) {
					var newtd = document.createElement('td');
					var tdText = document.createTextNode('\u00a0');
					newtd.style.width = '25%';
					newtd.style.height = '20%';
					adicionar_evento(newtd,'onclick',1);
					newtd.appendChild(tdText);
					newtr.appendChild(newtd);
				}
				tbody.appendChild(newtr);
			}
			tbody.childNodes[1].childNodes[0].id = tbody.childNodes[1].childNodes[0].style.backgroundColor = '#000000';
			tbody.childNodes[1].childNodes[1].id = tbody.childNodes[1].childNodes[1].style.backgroundColor = '#CC0000'; 
			tbody.childNodes[1].childNodes[2].id = tbody.childNodes[1].childNodes[2].style.backgroundColor = '#00CC00';
			tbody.childNodes[1].childNodes[3].id = tbody.childNodes[1].childNodes[3].style.backgroundColor = '#0000CC';
			tbody.childNodes[2].childNodes[0].id = tbody.childNodes[2].childNodes[0].style.backgroundColor = '#999999';
			tbody.childNodes[2].childNodes[1].id = tbody.childNodes[2].childNodes[1].style.backgroundColor = '#FF0000';
			tbody.childNodes[2].childNodes[2].id = tbody.childNodes[2].childNodes[2].style.backgroundColor = '#00FF00';
			tbody.childNodes[2].childNodes[3].id = tbody.childNodes[2].childNodes[3].style.backgroundColor = '#0000FF';
			tbody.childNodes[3].childNodes[0].id = tbody.childNodes[3].childNodes[0].style.backgroundColor = '#CCCCCC';
			tbody.childNodes[3].childNodes[1].id = tbody.childNodes[3].childNodes[1].style.backgroundColor = '#FF9999';
			tbody.childNodes[3].childNodes[2].id = tbody.childNodes[3].childNodes[2].style.backgroundColor = '#99FF99';
			tbody.childNodes[3].childNodes[3].id = tbody.childNodes[3].childNodes[3].style.backgroundColor = '#9999FF';
			tbody.childNodes[4].childNodes[0].id = tbody.childNodes[4].childNodes[0].style.backgroundColor = '#FFFFFF';
			tbody.childNodes[4].childNodes[1].id = tbody.childNodes[4].childNodes[1].style.backgroundColor = '#FFCCCC';
			tbody.childNodes[4].childNodes[2].id = tbody.childNodes[4].childNodes[2].style.backgroundColor = '#CCFFCC';
			tbody.childNodes[4].childNodes[3].id = tbody.childNodes[4].childNodes[3].style.backgroundColor = '#CCCCFF';
			table.appendChild(tbody);
			option_param[0] = table;
			/*Fim da tabela da paleta de cores do background da tag div*/

			/*Tabela da paleta de cores da fonte da tag div*/
			table = document.createElement('table');
			table_css = 'width:120px;border:1px solid #333;height:120px;font-family:Verdana;font-size:12px;text-align:center;float:left;margin:5px 0px 0px 5px;color:#000000;';
			atribuir_css(table,table_css);
			table.setAttribute('id','DIV');
			table.setAttribute('cellpadding','0');
			table.setAttribute('cellspacing','0');
			table.setAttribute('border','1');
			tbody = document.createElement('tbody');
			first_tr = document.createElement('tr');
			first_td = document.createElement('td');
			tbl_name = document.createTextNode('Font Color');
			first_td.appendChild(tbl_name);
			first_td.setAttribute('colSpan','4');
			first_td.style.backgroundColor = '#FFFFFF';
			first_tr.appendChild(first_td);
			tbody.appendChild(first_tr);
			for (var a=0;a<4;a++) {
				var newtr = document.createElement('tr');
				newtr.setAttribute('id','color');
				for (var b=0;b<4;b++) {
					var newtd = document.createElement('td');
					var tdText = document.createTextNode('\u00a0');
					newtd.style.width = '25%';
					newtd.style.height = '20%';
					adicionar_evento(newtd,'onclick',1);
					newtd.appendChild(tdText);
					newtr.appendChild(newtd);
				}
				tbody.appendChild(newtr);
			}
			tbody.childNodes[1].childNodes[0].id = tbody.childNodes[1].childNodes[0].style.backgroundColor = '#000000';
			tbody.childNodes[1].childNodes[1].id = tbody.childNodes[1].childNodes[1].style.backgroundColor = '#CC0000'; 
			tbody.childNodes[1].childNodes[2].id = tbody.childNodes[1].childNodes[2].style.backgroundColor = '#00CC00';
			tbody.childNodes[1].childNodes[3].id = tbody.childNodes[1].childNodes[3].style.backgroundColor = '#0000CC';
			tbody.childNodes[2].childNodes[0].id = tbody.childNodes[2].childNodes[0].style.backgroundColor = '#999999';
			tbody.childNodes[2].childNodes[1].id = tbody.childNodes[2].childNodes[1].style.backgroundColor = '#FF0000';
			tbody.childNodes[2].childNodes[2].id = tbody.childNodes[2].childNodes[2].style.backgroundColor = '#00FF00';
			tbody.childNodes[2].childNodes[3].id = tbody.childNodes[2].childNodes[3].style.backgroundColor = '#0000FF';
			tbody.childNodes[3].childNodes[0].id = tbody.childNodes[3].childNodes[0].style.backgroundColor = '#CCCCCC';
			tbody.childNodes[3].childNodes[1].id = tbody.childNodes[3].childNodes[1].style.backgroundColor = '#FF9999';
			tbody.childNodes[3].childNodes[2].id = tbody.childNodes[3].childNodes[2].style.backgroundColor = '#99FF99';
			tbody.childNodes[3].childNodes[3].id = tbody.childNodes[3].childNodes[3].style.backgroundColor = '#9999FF';
			tbody.childNodes[4].childNodes[0].id = tbody.childNodes[4].childNodes[0].style.backgroundColor = '#FFFFFF';
			tbody.childNodes[4].childNodes[1].id = tbody.childNodes[4].childNodes[1].style.backgroundColor = '#FFCCCC';
			tbody.childNodes[4].childNodes[2].id = tbody.childNodes[4].childNodes[2].style.backgroundColor = '#CCFFCC';
			tbody.childNodes[4].childNodes[3].id = tbody.childNodes[4].childNodes[3].style.backgroundColor = '#CCCCFF';
			table.appendChild(tbody);
			option_param[1] = table;
			/*Fim da tabela da paleta de cores de fonte da tag div*/

			/*Combo para escolha da família de fonte da tag div*/
   			var obj_select =  document.createElement('select');
			obj_select.setAttribute('id','fontFamily');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			var txtEscolha = document.createTextNode('Escolha a fonte');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','Arial');
			var txtOption1 = document.createTextNode('Arial');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','Tahoma');
			var txtOption2 = document.createTextNode('Tahoma');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','Trebuchet MS');
			var txtOption3 = document.createTextNode('Trebuchet MS');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','Verdana');
			var txtOption4 = document.createTextNode('Verdana');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			var select_css = 'font-family:Verdana;font-size:12px;float:left;width:130px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[2] = obj_select;
			/*Fim do combo para escolha da família de fonte da tag div*/

			/*Combo do alinhamento da fonte da tag div*/
   			obj_select =  document.createElement('select');
			obj_select.setAttribute('id','textAlign');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			txtEscolha = document.createTextNode('Alinhamento');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','left');
			txtOption1 = document.createTextNode('Esquerda');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','center');
			txtOption2 = document.createTextNode('Centralizado');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','right');
			txtOption3 = document.createTextNode('Direita');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','justify');
			txtOption4 = document.createTextNode('Justificado');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			select_css = 'font-family:Verdana;font-size:12px;float:left;width:120px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[3] = obj_select;
			/*Fim do combo de alinhamento da fonte da tag div*/

			/*Links do tamanho da fonte da tag div*/
			var span = document.createElement('span');
			var span_css = 'font-family:Verdana;font-size:12px;color:#000000;float:left;width:250px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(span,span_css);
			var span_text = document.createTextNode('Tamanho da fonte: ');
			span.appendChild(span_text);
			var span_link_aumenta = document.createElement('a');
			var span_link_diminui = document.createElement('a');
			var link_aumenta_text = document.createTextNode('A+');
			var espaco = document.createTextNode(' | ');
			var link_diminui_text = document.createTextNode('A-');
			span_link_aumenta.setAttribute('href','javascript:void(0)');
			span_link_aumenta.setAttribute('id','+1');
			span_link_diminui.setAttribute('href','javascript:void(0)');
			span_link_diminui.setAttribute('id','-1');
			adicionar_evento(span_link_aumenta,'onclick',4);	
			adicionar_evento(span_link_diminui,'onclick',4);	
	        span_link_aumenta.appendChild(link_aumenta_text);
	        span_link_diminui.appendChild(link_diminui_text);
			span.appendChild(span_link_aumenta);
			span.appendChild(espaco);
			span.appendChild(span_link_diminui);
			option_param[4] = span;
			/*Fim dos links do tamanho da fonte da tag div*/
			break;
		case 'P':
		    /*Tabela da paleta de cores de fonte da tag p*/
			table = document.createElement('table');
			table_css = 'width:120px;border:1px solid #333;height:120px;font-family:Verdana;font-size:12px;text-align:center;float:left;margin:5px 0px 0px 5px;color:#000000;';
			atribuir_css(table,table_css);
			table.setAttribute('id','P');
			table.setAttribute('cellpadding','0');
			table.setAttribute('cellspacing','0');
			table.setAttribute('border','1');
			tbody = document.createElement('tbody');
			first_tr = document.createElement('tr');
			first_td = document.createElement('td');
			tbl_name = document.createTextNode('Font Color');
			first_td.appendChild(tbl_name);
			first_td.setAttribute('colSpan','4');
			first_td.style.backgroundColor = '#FFFFFF';
			first_tr.appendChild(first_td);
			tbody.appendChild(first_tr);
			for (var a=0;a<4;a++) {
				var newtr = document.createElement('tr');
				newtr.setAttribute('id','color');
				for (var b=0;b<4;b++) {
					var newtd = document.createElement('td');
					var tdText = document.createTextNode('\u00a0');
					newtd.style.width = '25%';
					newtd.style.height = '20%';
					adicionar_evento(newtd,'onclick',1);
					newtd.appendChild(tdText);
					newtr.appendChild(newtd);
				}
				tbody.appendChild(newtr);
			}
			tbody.childNodes[1].childNodes[0].id = tbody.childNodes[1].childNodes[0].style.backgroundColor = '#000000';
			tbody.childNodes[1].childNodes[1].id = tbody.childNodes[1].childNodes[1].style.backgroundColor = '#CC0000'; 
			tbody.childNodes[1].childNodes[2].id = tbody.childNodes[1].childNodes[2].style.backgroundColor = '#00CC00';
			tbody.childNodes[1].childNodes[3].id = tbody.childNodes[1].childNodes[3].style.backgroundColor = '#0000CC';
			tbody.childNodes[2].childNodes[0].id = tbody.childNodes[2].childNodes[0].style.backgroundColor = '#999999';
			tbody.childNodes[2].childNodes[1].id = tbody.childNodes[2].childNodes[1].style.backgroundColor = '#FF0000';
			tbody.childNodes[2].childNodes[2].id = tbody.childNodes[2].childNodes[2].style.backgroundColor = '#00FF00';
			tbody.childNodes[2].childNodes[3].id = tbody.childNodes[2].childNodes[3].style.backgroundColor = '#0000FF';
			tbody.childNodes[3].childNodes[0].id = tbody.childNodes[3].childNodes[0].style.backgroundColor = '#CCCCCC';
			tbody.childNodes[3].childNodes[1].id = tbody.childNodes[3].childNodes[1].style.backgroundColor = '#FF9999';
			tbody.childNodes[3].childNodes[2].id = tbody.childNodes[3].childNodes[2].style.backgroundColor = '#99FF99';
			tbody.childNodes[3].childNodes[3].id = tbody.childNodes[3].childNodes[3].style.backgroundColor = '#9999FF';
			tbody.childNodes[4].childNodes[0].id = tbody.childNodes[4].childNodes[0].style.backgroundColor = '#FFFFFF';
			tbody.childNodes[4].childNodes[1].id = tbody.childNodes[4].childNodes[1].style.backgroundColor = '#FFCCCC';
			tbody.childNodes[4].childNodes[2].id = tbody.childNodes[4].childNodes[2].style.backgroundColor = '#CCFFCC';
			tbody.childNodes[4].childNodes[3].id = tbody.childNodes[4].childNodes[3].style.backgroundColor = '#CCCCFF';
			table.appendChild(tbody);
			option_param[0] = table;
			/*Fim tabela da paleta de cores de fonte da tag p*/

			/*Combo da família de fonte da tag p*/
   			var obj_select =  document.createElement('select');
			obj_select.setAttribute('id','fontFamily');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			var txtEscolha = document.createTextNode('Escolha a fonte');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','Arial');
			var txtOption1 = document.createTextNode('Arial');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','Tahoma');
			var txtOption2 = document.createTextNode('Tahoma');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','Trebuchet MS');
			var txtOption3 = document.createTextNode('Trebuchet MS');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','Verdana');
			var txtOption4 = document.createTextNode('Verdana');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			var select_css = 'font-family:Verdana;font-size:12px;float:left;width:130px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[1] = obj_select;
			/*Fim do combo da família de fonte da tag p*/

			/*Combo de alinhamento da fonte da tag p*/
   			obj_select =  document.createElement('select');
			obj_select.setAttribute('id','textAlign');
			obj_opescolha = document.createElement('option');
			obj_opescolha.setAttribute('disabled','disabled');
			obj_opescolha.setAttribute('selected','selected');
			txtEscolha = document.createTextNode('Alinhamento');
			obj_opescolha.appendChild(txtEscolha);			
            obj_option1 = document.createElement('option');
			obj_option1.setAttribute('value','left');
			txtOption1 = document.createTextNode('Esquerda');
			obj_option1.appendChild(txtOption1);
			obj_option2 = document.createElement('option');
			obj_option2.setAttribute('value','center');
			txtOption2 = document.createTextNode('Centralizado');
			obj_option2.appendChild(txtOption2);
			obj_option3 = document.createElement('option');
			obj_option3.setAttribute('value','right');
			txtOption3 = document.createTextNode('Direita');
			obj_option3.appendChild(txtOption3);
   		    obj_option4 = document.createElement('option');
			obj_option4.setAttribute('value','justify');
			txtOption4 = document.createTextNode('Justificado');
			obj_option4.appendChild(txtOption4);
			obj_select.appendChild(obj_opescolha);
    		obj_select.appendChild(obj_option1);
			obj_select.appendChild(obj_option2);
			obj_select.appendChild(obj_option3);
			obj_select.appendChild(obj_option4);
			select_css = 'font-family:Verdana;font-size:12px;float:left;width:130px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(obj_select,select_css);
        	adicionar_evento(obj_select,'onchange',2);	
			option_param[2] = obj_select;
			/*Fim do combo de alinhamento da fonte da tag p*/		
			
			/*Links do tamanho da fonte da tag p*/
			var span = document.createElement('span');
			var span_css = 'font-family:Verdana;font-size:12px;color:#000000;float:left;width:130px;border:1px solid #333;margin:5px 0px 0px 5px;';
			atribuir_css(span,span_css);
			var span_text = document.createTextNode('Tamanho da fonte: ');
			span.appendChild(span_text);
			var span_link_aumenta = document.createElement('a');
			var span_link_diminui = document.createElement('a');
			var link_aumenta_text = document.createTextNode('A+');
			var espaco = document.createTextNode(' | ');
			var link_diminui_text = document.createTextNode('A-');
			span_link_aumenta.setAttribute('href','javascript:void(0)');
			span_link_aumenta.setAttribute('id','+1');
			span_link_diminui.setAttribute('href','javascript:void(0)');
			span_link_diminui.setAttribute('id','-1');
			adicionar_evento(span_link_aumenta,'onclick',4);	
			adicionar_evento(span_link_diminui,'onclick',4);	
	        span_link_aumenta.appendChild(link_aumenta_text);
	        span_link_diminui.appendChild(link_diminui_text);
			span.appendChild(span_link_aumenta);
			span.appendChild(espaco);
			span.appendChild(span_link_diminui);
			option_param[3] = span;
			/*Fim dos links do tamanho da fonte da tag p*/
			break;
		default:
			return false;
	}
	if (option_param.length != 0) {
		for (i=0;i<option_param.length;i++) {
			document.getElementById('jslib_opt_param').appendChild(option_param[i]);
		}
		option_param.length = 0;
	}
}

// Função responsável pela alteração do layout da página. Ela altera o valor do atributo e tag especificadas.
function alterar_layout(tag,attr,value){
	ereg = /^(BODY|DIV|P|H1|H2|H3|H4|H5|H6|A|UL|OL|LI|SELECT|OPTION|IMG|INPUT|TEXTAREA|SPAN|TABLE|TR|TD|THEAD|TBODY|TFOOT|EM|FORM|LABEL)$/i;
	if(tag && ereg.test(tag)) {
		if (value != '') {
			for (i=0; i<document.getElementsByTagName(tag).length; i++) {
				if (document.getElementsByTagName(tag)[i].id == 'jslib') break;
				else {
					if (tag == 'BODY' && attr == 'textAlign' && document.body.style.setAttribute) {
						document.body.style.setAttribute('cssText','text-align:'+value);
					} else eval('document.getElementsByTagName(tag)[i].style.'+attr+' = "'+value+'";');
				}
			}
		}
	} else {
		alert('Tag não reconhecida!');
		return false;
	}
}

//Função que vai varrendo todos os elementos e pegando e modificando o tamanho da fonte nos mesmos.
function modifica_fonte_tags(tag,valor){
	for (i=0; i<document.getElementsByTagName(tag).length; i++) {
		if (document.getElementsByTagName(tag)[i].id == 'jslib') break;
		else {
			var y = document.body.currentStyle?document.getElementsByTagName(tag)[i].currentStyle.fontSize:document.defaultView.getComputedStyle(document.getElementsByTagName(tag)[i],null).getPropertyValue('font-size');
			y = y.substring(0,2);
			var tamanho = eval(y+valor);
			if (tamanho < 10) tamanho = 10;
			if (tamanho > 24) tamanho = 24;
			document.getElementsByTagName(tag)[i].style.fontSize = tamanho+'px';
		}
	}
}

//Função que modifica o tamanho da fonte
function mudar_valor_fonte(valor,inc) {
	if (!document.getElementById) return false;
	var tamanho = eval(valor+inc);
	if (tamanho < 9) tamanho = 9;
	if (tamanho > 24) tamanho = 24;
	document.body.style.fontSize = tamanho+'px';
}

// Função que retorna o valor de tamanho da fonte de um elemento
function pegar_valor_fonte() {
	if (!document.getElementById) return false;
	var x = document.body;
//IE
	if (x.currentStyle) var y = x.currentStyle.fontSize;
//Firefox
	else if (window.getComputedStyle) var y = document.defaultView.getComputedStyle(x,null).getPropertyValue('font-size');
	return y.substring(0,2);
}

// Função que aplica o css no objeto de acordo com o navegador utilizado
function atribuir_css(obj,style) {
//IE
	if(obj.style.setAttribute) {
		obj.style.setAttribute("cssText",style);
	}
//Firefox
	else {
		obj.setAttribute("style",style);
	}
}

// Função que dispara rotinas, de acordo com opção selecionada no parametro opcao, para os elementos indicados
function adicionar_evento(obj,evento,opcao){
//IE
	if (window.attachEvent) {
		if (opcao==0) obj.attachEvent(evento,function () {carregar_parametros(obj.value)});
		if (opcao==1) obj.attachEvent(evento,function () {
													var tag = obj.parentNode.parentNode.parentNode.id;
													var param = obj.parentNode.id;
													var value = obj.id;
													alterar_layout(tag,param,value);
													});
		if (opcao==2) obj.attachEvent(evento,function () {alterar_layout(document.getElementById('jslib_tagselect').value,obj.id,obj.value)});
		if (opcao==3) obj.attachEvent(evento,function () {mudar_valor_fonte(pegar_valor_fonte(),obj.id)});
		if (opcao==4) obj.attachEvent(evento,function () {modifica_fonte_tags(document.getElementById('jslib_tagselect').value,obj.id);
													});
		if (opcao==5) obj.attachEvent(evento,function () {mostra_jslib()});
		
	}
//Firefox
	if (window.addEventListener) {
		if (opcao==0) obj.addEventListener(evento.substr(2),function () { carregar_parametros(obj.value) },true);
		if (opcao==1) obj.addEventListener(evento.substr(2),function () {
																   var tag = obj.parentNode.parentNode.parentNode.id;
																   var param = obj.parentNode.id;
																   var value = obj.id;
																   alterar_layout(tag,param,value)},true);
     	if (opcao==2) obj.addEventListener(evento.substr(2),function () { alterar_layout(document.getElementById('jslib_tagselect').value,obj.id,obj.value)},true);
    	if (opcao==3) obj.addEventListener(evento.substr(2),function () { mudar_valor_fonte(pegar_valor_fonte(),obj.id); }, true);
		if (opcao==4) obj.addEventListener(evento.substr(2),function () { modifica_fonte_tags(document.getElementById('jslib_tagselect').value,obj.id); }, true);
		if (opcao==5) obj.addEventListener(evento.substr(2),function () { mostra_jslib() },true);
	}
}
// Função que limpa as opções de atributo de uma tag para o carregamento das opções de atributo de outra tag
function limpar_parametros(){
	param = document.getElementById('jslib_opt_param');
	if(param){
		while (param.childNodes[0]) param.removeChild(param.childNodes[0]);
	}
}