/*
 * MemoryScoreEntry.java
 *
 * Created on 4. Dezember 2003, 22:11
 */

import java.util.*;
import java.text.*;
import java.net.*;

/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryScoreEntry {
    
    /** Anzahl Punkte */
    private int m_nPoints;
    
    /** Spiellevel */
    private int m_nLevel;
    
    /** Anzahl Versuche */
    private int m_nAttempts;
    
    /** Spielzeit */
    private int m_nTime;
    
    /** Spielername */
    private String m_strName;
    
    /** Spieldatum */
    private String m_strDate;
    
    /** Creates a empty instance of MemoryScoreEntry */
    public MemoryScoreEntry() {
        m_nPoints = 0;
        m_strName = "";
        m_nTime = 0;
        m_nAttempts = 0;
        m_nLevel = 0;
        m_strDate = "";
    }
    
    /** Creates a new instance of MemoryScoreEntry */
    public MemoryScoreEntry(int nPoints, String strName, int nTime, int nAttempts, int nLevel, String strDate) {
        m_nPoints = nPoints;
        m_strName = strName;
        m_nTime = nTime;
        m_nAttempts = nAttempts;
        m_nLevel = nLevel;
        if(strDate.length() == 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            m_strDate = simpleDateFormat.format(new Date());
        }
        else {
            m_strDate = strDate;
        }
    }
    
    /** Points
     * @return Points
     */
    public int getPoints() {
        return m_nPoints;
    }
    
    /** Score header as formated String
     * @return Highscore header
     */
    public String getFormatedHeader() {
        return
        getFormatedString("Points", 7) +
        getFormatedString("Name", 22) +
        getFormatedString("Time", 5) +
        getFormatedString("Att.", 5) +
        getFormatedString("Lev.", 5) +
        getFormatedString("Date", 17);
    }
    
    /** Score entry as formated String
     * @return Score attributes as formated string
     */
    public String getFormatedScore() {
        return
        getFormatedString("" + m_nPoints, 7) +
        getFormatedString(m_strName, 22) +
        getFormatedString("" + m_nTime, 5) +
        getFormatedString("" + m_nAttempts, 5) +
        getFormatedString("" + m_nLevel, 5) +
        getFormatedString(m_strDate, 17);
    }
    
    /** Format String to specified length
     * @param str String to format
     * @param nLength New lenght of string
     * @return String with fixed lenght
     */
    private String getFormatedString(String str, int nLength) {
        while(str.length() < nLength) {
            str += " ";
        }
        return str.substring(0, nLength);
    }
    
    /** Score entry formated as a cookie
     * @return Score attributes as cookie
     */
    public String getCookieScore() {
        return "" +
        m_nPoints + ";" +
        getFormatedString(m_strName, 22).trim() + ";" +
        m_nTime + ";" +
        m_nAttempts + ";" +
        m_nLevel + ";" +
        m_strDate;
    }
    
   /** Score entry URL coded
     * @return URL coded score entry
     */
    public String getURLScore() {
        return "?p=" + m_nPoints + "&n=" + URLEncoder.encode(m_strName) + "&d=" + URLEncoder.encode(m_strDate) + "&l=" + m_nLevel + "&t=" + m_nTime + "&a=" + m_nAttempts;
    }

}
