/*
 * MemoryImageFieldContainer.java
 *
 * Created on 6. August 2002, 22:36
 */

import java.util.*;

/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryImageFieldContainer extends MemoryImageButtonContainer {

    int m_nSelected1 = -1;
    int m_nSelected2 = -1;
    
    /** Show card
     * @param strId Id of picture
     */
    public void showCard(String strId) {
        for(int i = 0; i < m_vectorImages.size(); i++) {
            if(((MemoryImageButton)m_vectorImages.elementAt(i)).getId().equals(strId)) {
                if(storeCard(i)) {
                    ((MemoryImageButton)m_vectorImages.elementAt(i)).setActive(false);
  
                }
            }
        }
    }

    /** Show card
     * @param nPosX X coordinate
     * @param nPosY Y coordinate
     */
    public void showCard(int nPosX, int nPosY) {
        for(int i = 0; i < m_vectorImages.size(); i++) {
            if(((MemoryImageButton)m_vectorImages.elementAt(i)).hasFocus(nPosX, nPosY)) {
                if(storeCard(i)) {
                   ((MemoryImageButton)m_vectorImages.elementAt(i)).setActive(false);
                }
            }
        }
    }

    /** Turn all cards
     */
    public void hideAllCards() {
        for(Enumeration e = m_vectorImages.elements(); e.hasMoreElements();) {
            ((MemoryImageButton)e.nextElement()).setActive(true);
        }
    }

    /** Alle Karte aufdecken
     */
    public void showAllCards() {
        for(Enumeration e = m_vectorImages.elements(); e.hasMoreElements();) {
            ((MemoryImageButton)e.nextElement()).setActive(false);
        }
    }

    /** Aufgedeckte Karte zwischenspeichern
     * @param nIndex Index der aufgedeckten Karte
     * @return false, wenn bereits 2 Karten aufgedeckt sind, sonst true
     */
    public boolean storeCard(int nIndex) {
        boolean bReturn = false;
        
        if(m_nSelected1 == -1 || m_nSelected2 == -1) {
            if(m_nSelected1 == -1 && m_nSelected2 == -1) {
                m_nSelected1 = nIndex;
            }
            else {
                m_nSelected2 = nIndex;
            }
            bReturn = true;
        }
        
        return bReturn;
    }
    
    /** Abfragen, ob 2 Karten aufgedeckt sind
     * @return true, wenn 2 Karten aufgedeckt sind, sonst false
     */
    public boolean hasTwoCards() {
        boolean bReturn = false;
        
        if(m_nSelected1 != -1 && m_nSelected2 != -1) {
            bReturn = true;
        }
        
        return bReturn;
    }

    /** Abfragen, ob die 2 Karten identisch sind
     * @return true, wenn 2 Karten identisch sind, sonst false
     */
    public boolean isHit() {
        boolean bReturn = false;
        
        if(m_nSelected1 != -1 && m_nSelected2 != -1) {
            String strId1 = ((MemoryImageButton)m_vectorImages.elementAt(m_nSelected1)).getId();
            String strId2 = ((MemoryImageButton)m_vectorImages.elementAt(m_nSelected2)).getId();
            if(strId1.equals(strId2)) {
                m_nSelected1 = -1;
                m_nSelected2 = -1;
                bReturn = true;
            }
        }
        
        return bReturn;
    }
    
    /** Die beiden aufgedeckten Karten zudecken
     */
    public void hideSelectedCards() {
        if(m_nSelected1 != -1) {
            ((MemoryImageButton)m_vectorImages.elementAt(m_nSelected1)).setActive(true);
            m_nSelected1 = -1;
        }
        if(m_nSelected2 != -1) {
            ((MemoryImageButton)m_vectorImages.elementAt(m_nSelected2)).setActive(true);
            m_nSelected2 = -1;
        }
    }
    
   /** Karten mischen
     */
    public void shuffle() {
        int nImages = m_vectorImages.size();
        int nCount = (int)Math.floor(Calendar.getInstance().get(Calendar.SECOND) * Math.random() + 60);

        for(int i = 0; i < nCount; i++)
        {
            int n1 = (int)Math.round(Math.random() * (nImages - 1));
            int n2 = (int)Math.round(Math.random() * (nImages - 1));
            //System.out.println(""+nCount+" "+n1+" "+n2);
            int nPosX1 = ((MemoryImageButton)m_vectorImages.elementAt(n1)).getX();
            int nPosY1 = ((MemoryImageButton)m_vectorImages.elementAt(n1)).getY();
            int nPosX2 = ((MemoryImageButton)m_vectorImages.elementAt(n2)).getX();
            int nPosY2 = ((MemoryImageButton)m_vectorImages.elementAt(n2)).getY();
            ((MemoryImageButton)m_vectorImages.elementAt(n1)).setPos(nPosX2, nPosY2);
            ((MemoryImageButton)m_vectorImages.elementAt(n2)).setPos(nPosX1, nPosY1);
        }  
    }
}
