/*
 * MemoryImageContainer.java
 *
 * Created on 4. August 2002, 14:05
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/** Container for images
 *
 * @author  Markus Eichenberger
 */
public class MemoryImageContainer {
 
    protected Vector m_vectorImages;
  
    /** MemoryImageContainer */
    public MemoryImageContainer() {
        m_vectorImages = new Vector();
    }
 
    /** Add MemoryImage to liste
     * @param memoryImage Instance of MemoryImage
     */
    public void add(MemoryImage memoryImage) {
       m_vectorImages.addElement(memoryImage);
   }
    
    /** Draw complete list
     * @param g Grafikkontext
     */    
    public void paint(Graphics g) {
        for(Enumeration e = m_vectorImages.elements(); e.hasMoreElements();) {
            ((MemoryImage)e.nextElement()).paint(g);
        }
    }

}
