/*
 * MemoryImageButtonContainer.java
 *
 * Created on 6. August 2002, 22:13
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 *
 * @author  Markus Eichenberger
 */
public class MemoryImageButtonContainer extends MemoryImageContainer {
    
    /** Is the mouse button over the button ?
     * @param nPosX Position of mouse in X
     * @param nPosY Position of mouse in Y
     * @return true if mouse is over the button
     */
    public boolean hasFocus(int nPosX, int nPosY) {
        boolean bReturn = false;
 
        for(Enumeration e = m_vectorImages.elements(); e.hasMoreElements();) {
            if(((MemoryImageButton)e.nextElement()).hasFocus(nPosX, nPosY)) {
                bReturn = true;
           }
        }
 
        return bReturn;
     }
    
    /** Mouseclick on button
     * @param nPosX Position of mouse in X
     * @param nPosY Position of mouse in Y
     * @return true if button clicked
     */
    public String getClickId(int nPosX, int nPosY) {
       String strReturn = "";
        
        for(int i = 0; i < m_vectorImages.size(); i++) {
            if(((MemoryImageButton)m_vectorImages.elementAt(i)).hasFocus(nPosX, nPosY)) {
                strReturn = ((MemoryImageButton)m_vectorImages.elementAt(i)).getId();
           }
        }
    
        return strReturn;
    }
    
    /** Activate / deactivate button
     * @param strId Id of buttons
     * @param bActive true=button aktive, false=button inaktive
     */
    public void setActive(String strId, boolean bActive) {
        for(int i = 0; i < m_vectorImages.size(); i++) {
            if(((MemoryImageButton)m_vectorImages.elementAt(i)).getId().equals(strId)) {
                ((MemoryImageButton)m_vectorImages.elementAt(i)).setActive(bActive);
           }
        }
    }

}
