/*
 * MemoryImage.java
 *
 * Created on 6. August 2002, 21:20
 */

import java.awt.*;
import java.awt.image.*;

/** Generalization of a picture
 *
 * @author  Markus Eichenberger
 */
public class MemoryImage extends Component {

    protected Image m_image1;
    protected int m_nPosX = 0;
    protected int m_nPosY = 0;
  
    /** Create a picture on position nPosX,nPosY
     * @param image1 Image for state active
     * @param nPosX Position of image in X
     * @param nPosY Position of image in Y
     */
    public MemoryImage(Image image1, int nPosX, int nPosY) {
        m_image1 = image1;
        m_nPosX = nPosX;
        m_nPosY = nPosY;
    }
    
    /** Draw the image
     * @param g Graphic context
     */
    public void paint(Graphics g) {
        g.drawImage(m_image1, m_nPosX, m_nPosY, this);
    }

    /** Get X coordiante
     * @return X coordiante
     */
    public int getX() {
        return m_nPosX;
    }

    /** Get Y coordiante
     * @return Y coordiante
     */
    public int getY() {
        return m_nPosY;
    }

    /** Set X and Y coordiante
     * @param nPosX X coordiante
     * @param nPosY Y coordiante
     */
    public void setPos(int nPosX, int nPosY) {
        m_nPosX = nPosX;
        m_nPosY = nPosY;
    }

}
